// Copyright (C) 2012-2017 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_LIB_SDL_MIXER_HH
#define NV_LIB_SDL_MIXER_HH

#include <nv/common.hh>
#include <nv/lib/sdl.hh>

#if NV_PLATFORM == NV_WINDOWS
#	if NV_ARCHITECTURE == NV_64BIT
#		define NV_SDL_MIXER_PATH "SDL2_mixer_64.dll"
#	else 
#		define NV_SDL_MIXER_PATH "SDL2_mixer.dll"
#	endif
#elif NV_PLATFORM == NV_APPLE
#	define NV_SDL_MIXER_PATH "SDL2_mixer.framework/SDL_mixer"
#else
#	define NV_SDL_MIXER_PATH "libSDL2_mixer-2.0.so.0"
#endif

extern "C" {

#define SDL_MIXER_MAJOR_VERSION	2
#define SDL_MIXER_MINOR_VERSION	0
#define SDL_MIXER_PATCHLEVEL	0

#define SDL_MIXER_VERSION(X)                        \
{                                                   \
	(X)->major = SDL_MIXER_MAJOR_VERSION;           \
	(X)->minor = SDL_MIXER_MINOR_VERSION;           \
	(X)->patch = SDL_MIXER_PATCHLEVEL;              \
}

#include <nv/lib/detail/sdl_mixer_types.inc>


#if defined(NV_SDL_DYNAMIC)
#	define NV_SDL_FUN( rtype, fname, fparams ) NV_SDL_API rtype (NV_SDL_APIENTRY *fname) fparams
#else
#	define NV_SDL_FUN( rtype, fname, fparams ) NV_SDL_API rtype NV_SDL_APIENTRY fname fparams
#endif
#include <nv/lib/detail/sdl_mixer_functions.inc>
#undef NV_SDL_FUN

}

namespace nv {
	/* Dynamic load support */
#	if defined( NV_SDL_DYNAMIC )
	bool load_sdl_mixer_library( const char* path = NV_SDL_MIXER_PATH );
#	else
	inline bool load_sdl_mixer_library( const char* path = "" ) { return true; }
#	endif
}

#endif // NV_LIB_SDL_MIXER_HH
