// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.
//
// TODO: fix behavior for exact fits (1024^2 atlas with border 0 only holds 9 256^2 images...)

#ifndef NV_GFX_TEXTURE_ATLAS_HH
#define NV_GFX_TEXTURE_ATLAS_HH

#include <nv/common.hh>
#include <nv/stl/math.hh>
#include <nv/gfx/image.hh>
#include <nv/stl/vector.hh>

namespace nv
{

	class texture_atlas : public image
	{
	public:
		texture_atlas( ivec2 size, uint32 depth, uint32 border = 1 );
		region get_region( ivec2 size );
		void clear();
		uint32 get_used() const { return m_used; }
	protected:
		int fit( uint32 index, ivec2 size );
		void merge();
	private:
		uint32 m_used;
		uint32 m_border;
		vector<ivec3> m_nodes;
	};

}

#endif // NV_GFX_TEXTURE_ATLAS_HH

