// Copyright (C) 2014-2017 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file handle.hh
 * @author Kornel Kisielewicz
 */

#ifndef NV_STL_HANDLE_HH
#define NV_STL_HANDLE_HH

#include <nv/common.hh>
#include <nv/stl/vector.hh>
#include <nv/stl/index_table.hh>

namespace nv
{

	template < 
		typename T = uint32, 
		unsigned IBITS = 16,
		unsigned CBITS = 16,
		typename TAG = void 
	>
	class handle
	{
	public:
		typedef T value_type;
		typedef TAG tag_type;
		static constexpr int INDEX_BITS   = IBITS;
		static constexpr int COUNTER_BITS = IBITS;
		static constexpr T MAX_INDEX   = (1 << IBITS) - 1;
		static constexpr T MAX_COUNTER = (1 << CBITS) - 1;

		constexpr handle() : m_index(0), m_counter(0) {}

		constexpr inline bool operator==(const handle& rhs) const {return m_index == rhs.m_index && m_counter == rhs.m_counter; }
		constexpr inline bool operator!=(const handle& rhs) const {return !(*this == rhs);}

		constexpr bool is_nil() const { return m_index == 0 && m_counter == 0; }
		constexpr bool is_valid() const { return !is_nil(); }
		constexpr operator bool() const { return is_valid(); }

		constexpr T index() const { return m_index; }
		//uint32 hash() const { return hash<T>()( T( m_counter << IBITS | m_index ) ); }
		constexpr uint32 hash() const { NV_ASSERT( false, "UNIMPLEMENTED!" ); return 0; }
	protected:
		T m_index   : IBITS;
		T m_counter : CBITS;

		constexpr handle( T a_index, T a_counter ) : m_index( a_index ), m_counter( a_counter ) {}
		template < typename H >
		friend class handle_operator;
	};


}

#endif // NV_STL_HANDLE_HH
