// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.
//
// TODO : prepare tests:
//  * correctness tests
//  * compatibility tests
//  * performance tests
// TODO : resolve should not take a lua_State

#ifndef NV_LUA_PATH_HH
#define NV_LUA_PATH_HH

#include <nv/common.hh>
#include <nv/stl/string.hh>
#include <nv/stl/utility.hh>

struct lua_State;

namespace nv
{
	namespace lua
	{

		class path
		{
		public:
			template < typename... Args >
			path( Args&&... args ) : m_count(0)
			{
				static_assert( sizeof...( Args ) < 8, "Path can only take up to 8 arguments!" );
				initialize( nv::forward<Args>( args )... );
			}

			string128 to_string() const;
			bool resolve( lua_State* L, bool global = true ) const;
		
		private:
			template < typename T >
			void initialize( T&& arg ) 
			{
				push( nv::forward<T>( arg ) );
				if ( m_count == 1 && m_elements[0].length ) parse();
			}

			template < typename T, typename... Args >
			void initialize( T&& arg, Args&&... args )
			{ 
				push( nv::forward<T>( arg ) );
				initialize( nv::forward<Args>( args )... );
			}

			void parse();
			void push( uint32 value );
			void push( string_view p );

		private:
			struct element
			{
				union
				{
					uint32      value;
					const char* str;
				};
				uint32      length;
			};

			element m_elements[8];
			uint32  m_count;
		};

	} // namespace lua

} // namespace nv

#endif // NV_LUA_PATH_HH
