// Copyright (C) 2013-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
* @file terminal.hh
* @author Kornel Kisielewicz epyon@chaosforge.org
* @brief terminal interface
*/

#ifndef NV_CORE_ASCII_PRINTER_HH
#define NV_CORE_ASCII_PRINTER_HH

#include <nv/common.hh>
#include <nv/stl/string.hh>
#include <nv/core/position.hh>
#include <nv/interface/terminal.hh>

namespace nv
{
	class ascii_printer
	{
	public:
		explicit ascii_printer( terminal * term );

		void print( char ch, const position& p, term_color color )
		{
			m_terminal->print( p, color, term_color(), ch );
		}
		void print( const string_view& text, const position& p, term_color color );
//		void print( const string_view& text, const position& p, term_color color, const rectangle& scissor );
		void frame( const nv::rectangle& area, const nv::string_view& border_chars, term_color color );

	protected:
		terminal * m_terminal;
	};

}

#endif // NV_CORE_ASCII_PRINTER_HH
