// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#include "nv/core/io_event.hh"

#include "nv/core/logging.hh"
#include "nv/core/types.hh"

using namespace nv;

const char* nv::get_key_name( key_code key )
{
	switch ( key )
	{
#	define NV_KEY( id, val ) case id : return #id;
#		include <nv/detail/key_list.inc>
#	undef NV_KEY
	NV_RETURN_COVERED_DEFAULT( "KEY_UNKNOWN" );
	};
}

const char* nv::get_mouse_name( mouse_code button )
{
	switch ( button )
	{
#	define NV_MOUSE( id, val ) case id : return #id;
#		include <nv/detail/mouse_list.inc>
#	undef NV_MOUSE
	NV_RETURN_COVERED_DEFAULT( "MOUSE_UNKNOWN" );
	};
}

const char* nv::get_io_event_name( io_event_code event )
{
	switch ( event )
	{
#	define NV_IO_EVENT( id ) case id : return #id;
#		include <nv/detail/io_event_list.inc>
#	undef NV_IO_EVENT
	NV_RETURN_COVERED_DEFAULT( "EV_UNKNOWN" );
	};
}

void nv::log_event( const io_event& e )
{
	NV_LOG_INFO( "Event: ", get_io_event_name( e.type ) );
}

void nv::register_io_types( type_database* db )
{
	db->create_type<key_code>()
#	define NV_KEY( id, val ) .value( #id, val )
#		include <nv/detail/key_list.inc>
#	undef NV_KEY
	;

	db->create_type<mouse_code>()
#	define NV_MOUSE( id, val ) .value( #id, val )
#		include <nv/detail/mouse_list.inc>
#	undef NV_MOUSE
	;

	db->create_type<io_event_code>()
#	define NV_IO_EVENT( id ) .value( #id, id )
#		include <nv/detail/io_event_list.inc>
#	undef NV_IO_EVENT
	;

	db->create_type<key_event>()
		.field( "window_id",&key_event::window_id )
		.field( "ascii",    &key_event::ascii )
		.field( "code",     &key_event::code )
		.field( "shift",    &key_event::shift )
		.field( "control",  &key_event::control )
		.field( "alt",      &key_event::alt )
		.field( "pressed",  &key_event::pressed );

	db->create_type<mouse_button_event>()
		.field( "window_id",&mouse_button_event::window_id )
		.field( "x",        &mouse_button_event::x )
		.field( "y",        &mouse_button_event::y )
		.field( "button",   &mouse_button_event::button )
		.field( "pressed",  &mouse_button_event::pressed )
		.field( "code",     &mouse_button_event::code );

	db->create_type<mouse_move_event>()
		.field( "window_id",&mouse_move_event::window_id )
		.field( "x",        &mouse_move_event::x )
		.field( "y",        &mouse_move_event::y )
		.field( "rx",       &mouse_move_event::rx )
		.field( "ry",       &mouse_move_event::ry )
		.field( "pressed",  &mouse_move_event::pressed )
		.field( "code",     &mouse_move_event::code );

	db->create_type<mouse_wheel_event>()
		.field( "window_id",&mouse_wheel_event::window_id )
		.field( "x",        &mouse_wheel_event::x )
		.field( "y",        &mouse_wheel_event::y );

	db->create_type<pad_button_event>()
		.field( "id",      &pad_button_event::id )
		.field( "button",  &pad_button_event::button )
		.field( "pressed", &pad_button_event::pressed );

	db->create_type<pad_axis_event>()
		.field( "id",      &pad_axis_event::id )
		.field( "axis",    &pad_axis_event::axis )
		.field( "value",   &pad_axis_event::value );

	db->create_type<joy_button_event>()
		.field( "id",      &joy_button_event::id )
		.field( "button",  &joy_button_event::button )
		.field( "pressed", &joy_button_event::pressed );

	db->create_type<joy_axis_event>()
		.field( "id",      &joy_axis_event::id )
		.field( "axis",    &joy_axis_event::axis )
		.field( "value",   &joy_axis_event::value );

	db->create_type<joy_hat_event>()
		.field( "id",      &joy_hat_event::id )
		.field( "hat",     &joy_hat_event::hat )
		.field( "value",   &joy_hat_event::value );

	db->create_type<joy_ball_event>()
		.field( "id",      &joy_ball_event::id )
		.field( "ball",    &joy_ball_event::ball )
		.field( "rx",      &joy_ball_event::rx )
		.field( "ry",      &joy_ball_event::ry );

	db->create_type<resize_event>()
		.field( "x",       &resize_event::x )
		.field( "y",       &resize_event::y );

	db->create_type<active_event>()
		.field( "gain",    &active_event::gain );

	db->create_type<system_event>()
		.field( "sys_type", &system_event::sys_type )
		.field( "param1",   &system_event::param1 )
		.field( "param2",   &system_event::param2 );

	db->create_type<io_event>()
		.field( "type", &io_event::type )
		.union_field( "key",     &io_event::key,    "type", EV_KEY )
		.union_field( "mbutton", &io_event::mbutton,"type", EV_MOUSE_BUTTON )
		.union_field( "mmove",   &io_event::mmove,  "type", EV_MOUSE_MOVE )
		.union_field( "mwheel",  &io_event::mwheel, "type", EV_MOUSE_WHEEL )
		.union_field( "pbutton", &io_event::pbutton,"type", EV_PAD_BUTTON )
		.union_field( "paxis",   &io_event::paxis,  "type", EV_PAD_AXIS )
		.union_field( "jbutton", &io_event::jbutton,"type", EV_JOY_BUTTON )
		.union_field( "jaxis",   &io_event::jaxis,  "type", EV_JOY_AXIS )
		.union_field( "jhat",    &io_event::jhat,   "type", EV_JOY_HAT )
		.union_field( "jball",   &io_event::jball,  "type", EV_JOY_BALL )
		.union_field( "resize",  &io_event::resize, "type", EV_ACTIVE )
		.union_field( "active",  &io_event::active, "type", EV_RESIZE )
		.union_field( "system",  &io_event::system, "type", EV_SYSTEM );

}
