#include "nv/core/types.hh"

#include "nv/interface/clear_state.hh"
#include "nv/interface/render_state.hh"
#include "nv/stl/string.hh"

using namespace nv;

void nv::register_core_types( type_database* db )
{
	db->create_type<bool>();
	db->create_type<char>();
	db->create_type<uint8>();
	db->create_type<sint8>();
	db->create_type<uint16>();
	db->create_type<sint16>();
	db->create_type<uint32>();
	db->create_type<sint32>();
	db->create_type<uint64>();
	db->create_type<sint64>();
	db->create_type<f32>();
	db->create_type<f64>();
	db->create_type<vec2>();
	db->create_type<vec3>();
	db->create_type<vec4>();
	db->create_type<ivec2>();
	db->create_type<ivec3>();
	db->create_type<ivec4>();
	db->create_type<quat>();
	db->create_type<string32>();
	db->create_type<string64>();
	db->create_type<string128>();
	db->create_type<string256>();

	db->create_type<color_mask>()
		.field( "red",   &color_mask::red )
		.field( "green", &color_mask::green )
		.field( "blue",  &color_mask::blue )
		.field( "alpha", &color_mask::alpha )
		;

	db->create_type<scissor_test>()
		.field( "enabled", &scissor_test::enabled )
		.field( "pos",     &scissor_test::pos )
		.field( "dim",     &scissor_test::dim )
		;

	db->create_type<buffer_mask>()
		.value( "NO_BUFFER",              buffer_mask::NO_BUFFER )
		.value( "COLOR_BUFFER",           buffer_mask::COLOR_BUFFER )
		.value( "DEPTH_BUFFER",           buffer_mask::DEPTH_BUFFER )
		.value( "STENCIL_BUFFER",         buffer_mask::STENCIL_BUFFER )
		.value( "COLOR_AND_DEPTH_BUFFER", buffer_mask::COLOR_AND_DEPTH_BUFFER )
		.value( "ALL_BUFFERS",            buffer_mask::ALL_BUFFERS )
		;

	db->create_type<clear_state>()
		.field( "scissor_test",              &clear_state::scissor_test )
		.field( "color_mask",                &clear_state::color_mask )
		.field( "depth_mask",                &clear_state::depth_mask )
		.field( "front_stencil_mask",        &clear_state::front_stencil_mask )
		.field( "back_stencil_mask",         &clear_state::back_stencil_mask )
		.field( "buffers",                   &clear_state::buffers )
		.field( "color",                     &clear_state::color )
		.field( "depth",                     &clear_state::depth )
		.field( "stencil",                   &clear_state::stencil )
		;

	db->create_type<depth_test::function_type>()
		.value( "NEVER",            depth_test::function_type::NEVER )
		.value( "LESS",             depth_test::function_type::LESS )
		.value( "EQUAL",            depth_test::function_type::EQUAL )
		.value( "LESS_OR_EQUAL",    depth_test::function_type::LESS_OR_EQUAL )
		.value( "GREATER",          depth_test::function_type::GREATER )
		.value( "NOT_EQUAL",        depth_test::function_type::NOT_EQUAL )
		.value( "GREATER_OR_EQUAL", depth_test::function_type::GREATER_OR_EQUAL )
		.value( "ALWAYS",           depth_test::function_type::ALWAYS )
		;

	db->create_type<depth_test>()
		.field( "enabled", &depth_test::enabled )
		.field( "function", &depth_test::function )
		;

	db->create_type<polygon_mode::fill_type>()
		.value( "POINT", polygon_mode::fill_type::POINT )
		.value( "LINE",  polygon_mode::fill_type::LINE )
		.value( "FILL",  polygon_mode::fill_type::FILL )
		;

	db->create_type<polygon_mode>()
		.field( "fill", &polygon_mode::fill )
		;

	db->create_type<blending::factor>()
		.value( "ZERO",                     blending::factor::ZERO )
		.value( "ONE",                      blending::factor::ONE )
		.value( "SRC_COLOR",                blending::factor::SRC_COLOR )
		.value( "SRC_ALPHA",                blending::factor::SRC_ALPHA )
		.value( "DST_COLOR",                blending::factor::DST_COLOR )
		.value( "DST_ALPHA",                blending::factor::DST_ALPHA )
		.value( "CONSTANT_COLOR",           blending::factor::CONSTANT_COLOR )
		.value( "CONSTANT_ALPHA",           blending::factor::CONSTANT_ALPHA )
		.value( "ONE_MINUS_SRC_COLOR",      blending::factor::ONE_MINUS_SRC_COLOR )
		.value( "ONE_MINUS_SRC_ALPHA",      blending::factor::ONE_MINUS_SRC_ALPHA )
		.value( "ONE_MINUS_DST_COLOR",      blending::factor::ONE_MINUS_DST_COLOR )
		.value( "ONE_MINUS_DST_ALPHA",      blending::factor::ONE_MINUS_DST_ALPHA )
		.value( "ONE_MINUS_CONSTANT_COLOR", blending::factor::ONE_MINUS_CONSTANT_COLOR )
		.value( "ONE_MINUS_CONSTANT_ALPHA", blending::factor::ONE_MINUS_CONSTANT_ALPHA )
		.value( "SRC_ALPHA_SATURATE",       blending::factor::SRC_ALPHA_SATURATE )
		;

	db->create_type<blending::equation>()
		.value( "ADD",              blending::equation::ADD )
		.value( "MINIMUM",          blending::equation::MINIMUM )
		.value( "MAXIMUM",          blending::equation::MAXIMUM )
		.value( "SUBTRACT",         blending::equation::SUBTRACT )
		.value( "REVERSE_SUBTRACT", blending::equation::REVERSE_SUBTRACT )
		;

	db->create_type<blending>()
		.field( "enabled",          &blending::enabled )
		.field( "src_rgb_factor",   &blending::src_rgb_factor )
		.field( "src_alpha_factor", &blending::src_alpha_factor )
		.field( "dst_rgb_factor",   &blending::dst_rgb_factor )
		.field( "dst_alpha_factor", &blending::dst_alpha_factor )
		.field( "rgb_equation",     &blending::rgb_equation )
		.field( "alpha_equation",   &blending::alpha_equation )
		.field( "color",            &blending::color )
		;

	db->create_type<stencil_test_face::operation>()
		.value( "ZERO",           stencil_test_face::operation::ZERO )
		.value( "INVERT",         stencil_test_face::operation::INVERT )
		.value( "KEEP",           stencil_test_face::operation::KEEP )
		.value( "REPLACE",        stencil_test_face::operation::REPLACE )
		.value( "INCREMENT",      stencil_test_face::operation::INCREMENT )
		.value( "DECREMENT",      stencil_test_face::operation::DECREMENT )
		.value( "INCREMENT_WRAP", stencil_test_face::operation::INCREMENT_WRAP )
		.value( "DECREMENT_WRAP", stencil_test_face::operation::DECREMENT_WRAP )
		;

	db->create_type<stencil_test_face::function_type>()
		.value( "NEVER",            stencil_test_face::function_type::NEVER )
		.value( "LESS",             stencil_test_face::function_type::LESS )
		.value( "EQUAL",            stencil_test_face::function_type::EQUAL )
		.value( "LESS_OR_EQUAL",    stencil_test_face::function_type::LESS_OR_EQUAL )
		.value( "GREATER",          stencil_test_face::function_type::GREATER )
		.value( "NOT_EQUAL",        stencil_test_face::function_type::NOT_EQUAL )
		.value( "GREATER_OR_EQUAL", stencil_test_face::function_type::GREATER_OR_EQUAL )
		.value( "ALWAYS",           stencil_test_face::function_type::ALWAYS )
		;

	db->create_type<stencil_test_face>()
		.field( "op_fail",       &stencil_test_face::op_fail )
		.field( "op_depth_pass", &stencil_test_face::op_depth_pass )
		.field( "op_depth_fail", &stencil_test_face::op_depth_fail )
		.field( "function",      &stencil_test_face::function )
		.field( "ref_value",     &stencil_test_face::ref_value )
		.field( "mask",          &stencil_test_face::mask )
		;

	db->create_type<stencil_test>()
		.field( "enabled",       &stencil_test::enabled )
		.field( "front_face",    &stencil_test::front_face )
		.field( "back_face",     &stencil_test::back_face )
		;

	db->create_type<culling::face_type>()
		.value( "FRONT",          culling::face_type::FRONT )
		.value( "BACK",           culling::face_type::BACK )
		.value( "FRONT_AND_BACK", culling::face_type::FRONT_AND_BACK )
		;

	db->create_type<culling::order_type>()
		.value( "CW",  culling::order_type::CW )
		.value( "CCW", culling::order_type::CCW )
		;

	db->create_type<culling>()
		.field( "enabled", &culling::enabled )
		.field( "face",    &culling::face )
		.field( "order",   &culling::order )
		;

	db->create_type<depth_range>()
		.field( "near", &depth_range::near )
		.field( "far",  &depth_range::far )
		;

	db->create_type<render_state>()
		.field( "stencil_test", &render_state::stencil_test )
		.field( "depth_test",   &render_state::depth_test )
		.field( "scissor_test", &render_state::scissor_test )
		.field( "depth_range",  &render_state::depth_range )
		.field( "blending",     &render_state::blending )
		.field( "culling",      &render_state::culling )
		.field( "color_mask",   &render_state::color_mask )
		.field( "polygon_mode", &render_state::polygon_mode )
		.field( "multisample",  &render_state::multisample )
		.field( "depth_mask",   &render_state::depth_mask )
		;
}

