local NV_BT_SFX = ""
if NV_RUNTIME == "dcrt" then
	NV_BT_SFX = "_dcrt"
end

function nv_bullet_configure( dir, subdir, suffix )
	suffix = suffix or ""
	links 
	{
		"BulletCollision"..suffix..NV_BT_SFX,
		"BulletDynamics"..suffix..NV_BT_SFX,
		"BulletSoftBody"..suffix..NV_BT_SFX,
		"LinearMath"..suffix..NV_BT_SFX,
	}
	libdirs { dir.."lib/"..subdir.."/" }
	includedirs { dir.."src/" }
end

project "nv-bullet"
	location (_ACTION.."/"..NV_RUNTIME)
	language "C++"
	kind "StaticLib"
	files { "nv/bullet/**.hh", "src/bullet/**.cc" }
	includedirs { 
		"../nv"
	}
	links { "nv-core", "nv-gl", "nv-formats", "nv-lua", "nv-lib", "nv-io", "nv-gfx" }

	configuration "debug"
		nv_bullet_configure( "D:/Libraries/bullet2/", "Debug", "_debug" )

	configuration "not debug"
		nv_bullet_configure( "D:/Libraries/bullet2/", "Release" )


