// Copyright (C) 2016-2016 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_LUA_TEMPLATES_HH
#define NV_LUA_TEMPLATES_HH

#include <nv/common.hh>
#include <nv/stl/math.hh>
#include <nv/lua/lua_values.hh>

namespace nv
{
	namespace lua
	{

		namespace detail
		{
			template < typename T >
			int clone_impl( lua_State* L )
			{
				pass_traits<T>::push( L, pass_traits<T>::to( L, 1 ) );
				return 1;
			}

			template < typename T >
			int eq_impl( lua_State* L )
			{
				lua_pushboolean( L, pass_traits<T>::to( L, 1 ) == pass_traits<T>::to( L, 1 ) );
				return 1;
			}

			template < typename T, typename Constructor >
			int new_impl( lua_State* L )
			{
				pass_traits<T>::push( L, Constructor::construct( L, 1 ) );
				return 1;
			}

			template < typename T, typename Constructor >
			int call_impl( lua_State* L )
			{
				pass_traits<T>::push( L, Constructor::construct( L, 2 ) );
				return 1;
			}
		}

	}

}


#endif // NV_LUA_TEMPLATES_HH
