// Copyright (C) 2013-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file terminal.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief terminal interface
 */

#ifndef NV_INTERFACE_TERMINAL_HH
#define NV_INTERFACE_TERMINAL_HH

#include <nv/common.hh>
#include <nv/core/position.hh>
#include <nv/core/io_event.hh>
#include <nv/core/term_color.hh>

namespace nv
{


	class terminal
	{
	public:	
		/**
		 * Constructor
		 */
		terminal( dimension size ) : m_cursor(1,1), m_size( size ) {}

        /**
         * Update the screen
         */
        virtual void update() = 0;

        /**
         * Print a character of the given color to the screen memory
         */
        virtual void print( position p, term_color fgcolor, term_color bgcolor, char ch ) = 0;

        /**
		 * Clear screen memory
         */
        virtual void clear( rectangle r, term_color fgcolor, term_color bgcolor ) = 0;

        /**
         * Clear screen memory
         */
        virtual void clear() = 0;

        /**
         * Polls event
         */
        virtual bool poll( io_event& kevent ) = 0;

		/**
		 * Set cursor position
		 */
		virtual void set_cursor( position p )
		{
			m_cursor = p;
		}

		/**
		 * Show cursor
		 */
		virtual void show_cursor() = 0;

		/**
		 * Hide cursor
		 */
		virtual void hide_cursor() = 0;

	public: // other methods

		/**
		 * Get cursor position
		 */
		virtual position get_cursor() const { return m_cursor; }

		/**
		 * Get the size
		 */
		virtual dimension get_size() const { return m_size; }

		/**
		 * Virtual destructor
		 */
		virtual ~terminal() {}

	protected:
		position  m_cursor;
		dimension m_size;
	};
}

#endif // NV_INTERFACE_TERMINAL_HH
