// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file clear_state.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief Clear state class
 */

#ifndef NV_INTERFACE_CLEAR_STATE_HH
#define NV_INTERFACE_CLEAR_STATE_HH

#include <nv/common.hh>
#include <nv/stl/math.hh>

namespace nv
{

	struct color_mask
	{
		bool red;
		bool green;
		bool blue;
		bool alpha;

		color_mask() : red( true ), green( true ), blue( true ), alpha( true ) {}
		color_mask( bool r, bool g, bool b, bool a )
			: red( r ), green( g ), blue( b ), alpha( a ) {}

		bool operator==(const color_mask& rhs) const
		{
			return (rhs.red == red) && (rhs.green == green) && (rhs.blue == blue) && (rhs.alpha == alpha);
		}
		bool operator!=(const color_mask& rhs) const
		{
			return !operator==(rhs);
		}
	};

	struct scissor_test
	{
		bool enabled;
		ivec2 pos;
		ivec2 dim;

		scissor_test() :
		enabled( false ),
			pos(), dim()
		{}
	};

	enum buffer_mask
	{
		NO_BUFFER = 0,
		COLOR_BUFFER = 1,
		DEPTH_BUFFER = 2,
		STENCIL_BUFFER = 4,
		COLOR_AND_DEPTH_BUFFER = COLOR_BUFFER | DEPTH_BUFFER,
		ALL_BUFFERS = COLOR_BUFFER | DEPTH_BUFFER | STENCIL_BUFFER
	};

	struct clear_state
	{
		nv::scissor_test scissor_test;
		nv::color_mask color_mask;
		bool depth_mask;
		uint32 front_stencil_mask;
		uint32 back_stencil_mask;

		buffer_mask buffers;
		vec4 color;
		float depth;
		int stencil;

		clear_state() 
			: scissor_test(), color_mask(), depth_mask( true ), 
			  front_stencil_mask( uint32(-1) ), back_stencil_mask( uint32(-1) ),
			  buffers( ALL_BUFFERS ), color( vec4(0,0,0,1) ), depth( 1.0f ), stencil( 0 ) {}
	};

} // namespace nv

NV_RTTI_DECLARE( nv::color_mask )
NV_RTTI_DECLARE( nv::scissor_test )
NV_RTTI_DECLARE( nv::clear_state )
NV_RTTI_DECLARE( nv::buffer_mask )


#endif // NV_INTERFACE_CLEAR_STATE_HH
