// Copyright (C) 2015-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_IMAGE_PNG_LOADER_HH
#define NV_IMAGE_PNG_LOADER_HH

#include <nv/common.hh>
#include <nv/interface/image_loader.hh>
#include <nv/interface/image_data.hh>
#include <nv/stl/stream.hh>

namespace nv
{

	class png_loader : public image_loader
	{
	public:
		png_loader();
		virtual bool get_info( stream&, image_format& format, ivec2& size );
		virtual bool test( stream& );
		virtual image_data* load( stream& );
		virtual image_data* load( stream&, image_format format );
	};

}

#endif // NV_IMAGE_PNG_LOADER_HH
