// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file gui_environment.hh
 * @author Kornel Kisielewicz
 * @brief GUI Environment (root)
 */

#ifndef NV_GUI_ENVIRONMENT_HH
#define NV_GUI_ENVIRONMENT_HH

#include <nv/gui/gui_element.hh>
#include <nv/gui/gui_style.hh>
#include <nv/lua/lua_state.hh>
#include <nv/core/io_event.hh>
#include <nv/interface/window.hh>

namespace nv
{

	namespace gui
	{

		class environment
		{
		public:
			environment( renderer* r );
			// temporary
			void load_style( const string_view& filename );
			handle create_element( const rectangle& r );
			handle create_element( handle parent, const rectangle& r );
			void set_text( handle e, const string_twine& text );
			void set_class( handle e, const string_view& text );
			void set_on_click( handle e, const function< void() >& on_click );
			void update();
			void draw();
			void destroy_element( handle e );
			bool process_io_event( const io_event& ev );
			renderer* get_renderer() { return m_renderer; }
			string_view get_string( shash64 h );
			virtual ~environment();
		protected:
			bool set_selected( handle e );
			handle get_element( const position& p );
			void add_child( handle child );
			void add_child( handle parent, handle child );
			void remove_child( handle parent, handle child );
			void destroy_children( handle e );
			void update( handle e, uint32 elapsed );
			void draw( handle e );
			bool process_io_event( handle e, const io_event& ev );
			handle get_deepest_child( handle e, const position& p );
			void move_to_top( handle child );
			void set_relative( handle e, const rectangle& r );
			void set_relative( handle e, const position& p );
			void recalculate_absolute( handle e );

			handle_store< element, handle > m_elements;
			string_table  m_strings;
			renderer*     m_renderer;
			handle        m_screen;
			position      m_mouse_position;
			handle        m_selected;
		};

	} // namespace gui

} // namespace nv

#endif // NV_GUI_ENVIRONMENT_HH
