// Copyright (C) 2014-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_GFX_DEBUG_DRAW_HH
#define NV_GFX_DEBUG_DRAW_HH

#include <nv/common.hh>
#include <nv/stl/math.hh>
#include <nv/stl/vector.hh>
#include <nv/interface/context.hh>

namespace nv
{
	struct debug_vtx
	{
		vec3 position;
		vec3 color;

		debug_vtx( const vec3& v, const vec3& c )
			: position(v), color( c ) {}
	};

	class debug_data
	{
	public:
		debug_data( context* a_context );
		void update();
		void reset();
		program       get_program()      { return m_program; }
		vertex_array  get_vertex_array() { return m_va; }
		uint32        get_count()        { return m_data.size(); }

		void push_line( const vec3& a, const vec3& b, const vec3& color );
		void push_aabox( const vec3& a, const vec3& b, const vec3& color );
		void push_gizmo( const nv::transform& tr, float length );
		void push_wire_capsule( const transform& tr, float radius, float height );
		~debug_data();
	private:
		context*            m_context;
		program             m_program;
		vertex_array        m_va;
		buffer              m_vb;
		uint32              m_buffer_size;
		vector< debug_vtx > m_data;
	};

}

#endif // NV_GFX_DEBUG_DRAW_HH
