// Copyright (C) 2016-2016 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_ENGINE_SHADOW_HH
#define NV_ENGINE_SHADOW_HH

#include <nv/common.hh>
#include <nv/stl/math.hh>
#include <nv/stl/vector.hh>
#include <nv/core/resource.hh>
#include <nv/interface/context.hh>
#include <nv/engine/render_pass.hh>

namespace nv
{

	class shadow_data
	{
	public:
		shadow_data() : m_map_size(0) {}
		void initialize( context* context, uint32 count, uint32 map_size, const render_pass& pass_base );
		void initialize( context* context, uint32 count, uint32 map_size, const render_pass& pass_base, const render_pass& color_base );
		uint32 size() const { return m_passes.size(); }
		uint32 map_size() const { return m_map_size; }
		texture textures() const { return m_maps; }
		texture color_textures() const { return m_color_maps; }
		bool has_color() const { return m_color_passes.size() > 0; }
		const render_pass& pass( uint32 i ) const { return m_passes[i]; }
		const render_pass& color_pass( uint32 i ) const { return m_color_passes[i]; }
	protected:
		uint32                m_map_size;
		texture               m_maps;
		texture               m_color_maps;
		vector< render_pass > m_passes;
		vector< render_pass > m_color_passes;
	};


}

#endif // NV_ENGINE_SHADOW_HH
