// Copyright (C) 2016-2016 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file ragdoll_manager.hh
 * @author Kornel Kisielewicz
 * @brief ragdoll manager
 */

#ifndef NV_ENGINE_RAGDOLL_MANAGER_HH
#define NV_ENGINE_RAGDOLL_MANAGER_HH

#include <nv/common.hh>
#include <nv/interface/physics_world.hh>
#include <nv/engine/resource_system.hh>
#include <nv/engine/model_manager.hh>

namespace nv
{
	struct ragdoll_part_data
	{
		shash64         name;
		collision_shape shape;
		float           radius;
		float           length;
		uint32          bone_id;
		sint32          parent_idx;
		f32             mass;
		bool            cone_twist;
		vec3            limits;
	};

	struct ragdoll_data
	{
		vector< ragdoll_part_data > parts;
		vector< bool >              bone_mask;
	};

	NV_RTTI_DECLARE_NAME( nv::ragdoll_data, "ragdoll_data" )

	class ragdoll_manager : public lua_resource_manager< ragdoll_data >
	{
	public:
		ragdoll_manager( model_manager* model );
		virtual void initialize( lua::state* state );
		virtual void initialize( physics_world* world ) { m_world = world; }
		virtual string_view get_storage_name() const { return "ragdolls"; }
		virtual string_view get_resource_name() const { return "ragdoll"; }
	protected:
		virtual bool load_resource( lua::table_guard& table, shash64 id );
		virtual void release( ragdoll_data* p );
		bool load_ragdoll( lua::table_guard& table, resource< animator_bind_data > rbind, ragdoll_data* data, int pindex );
	private:
		physics_world* m_world;
		model_manager* m_model;
	};

}

#endif // NV_ENGINE_RAGDOLL_MANAGER_HH
