// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.
/**
 * @file stream.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief stream interface
 */

#ifndef NV_STL_FILE_SYSTEM_HH
#define NV_STL_FILE_SYSTEM_HH

#include <nv/common.hh>
#include <nv/stl/string.hh>
#include <nv/stl/stream.hh>

namespace nv
{

	class file_system
	{
	protected:
		file_system() {}
	public:
		virtual ~file_system() {}
		virtual const_string slurp( const string_view& path ) = 0;
		virtual bool exists( const string_view& path ) = 0;
		virtual stream* open( const string_view& path, const string_view& mode = "rb" ) = 0;

	};

} // namespace nv

#endif // NV_STL_FILE_SYSTEM_HH
