// Copyright (C) 2016-2016 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_LUA_TYPES_HH
#define NV_LUA_TYPES_HH

#include <nv/common.hh>
#include <nv/core/types.hh>
#include <nv/stl/type_traits/properties.hh>
#include <nv/lua/lua_values.hh>
#include <nv/lua/lua_state.hh>

/*
#define NV_LUA_RTTI_DECLARE( type ) struct pass_traits< type > : nv::lua::lua_rtti_pass_traits< type > {}
*/
namespace nv
{
	namespace lua
	{
/*
		template < typename T >
		struct lua_rtti_pass_traits
		{
			typedef T value_type;
			static const char* metatable()
			{
				return nv::rtti_type_hash<T>::name();
			}
			static void push( lua_State *L, const value_type& v )
			{
				detail::push_userdata< value_type >( L, v, metatable() );
			}
			static value_type to( lua_State *L, int index )
			{
				// TODO: ASSERT?
				value_type* result = detail::to_userdata< value_type >( L, index, metatable() );
				return result ? *result : value_type();
			}
			static value_type to( lua_State *L, int index, const value_type& def )
			{
				value_type* result = detail::to_userdata< value_type >( L, index, metatable() );
				return result ? *result : def;
			}
		};

		template < typename T >
		void register_lua_rtti_type( const string_view& name, lua::state* state )
		{
			const type_database* db = state->get_type_db();
			register_lua_rtti_type( name, state, db->get_type<T>() )
		}


		void register_lua_rtti_type( const string_view& name, lua::state* state, const type_entry* entry );
		*/

		bool read_rtti_type( lua::state* state, const type_entry* entry, void* object, int index );

		template < typename T >
		void push_rtti_proxy( lua::state* state, T* object );
	}
}

#endif // NV_LUA_TYPES_HH

