// Copyright (C) 2014-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file animated_mesh.hh
 * @author Kornel Kisielewicz
 * @brief animated_mesh
 */

#ifndef NV_INTERFACE_ANIMATED_MESH_HH
#define NV_INTERFACE_ANIMATED_MESH_HH

#include <nv/common.hh>
#include <nv/stl/math.hh>
#include <nv/core/transform.hh>
#include <nv/interface/context.hh>

namespace nv
{

#if 0
	class animation_entry
	{
	public:
		animation_entry( shash64 name, bool looping, uint32 frame_rate, uint32 a_start, uint32 a_end ) : m_name( name ), m_looping( looping ), m_fps( frame_rate ),
		m_fstart( a_start ), m_fend( a_end ) {}
		shash64 get_name() const { return m_name; }
		uint32 get_fps() const { return m_fps; }
		// TODO : if loop +1?
		uint32 get_frame_count() const { return m_fend - m_fstart; }
		uint32 get_start_frame() const { return m_fstart; }
		uint32 get_end_frame() const  { return m_fend; }
		bool is_looping() const { return m_looping; }
		void set_frame_range( uint32 a_start, uint32 a_end )
		{
			m_fstart = a_start;
			m_fend   = a_end;
		}
		void set_fps( uint32 rate )
		{
			m_fps = rate;
		}
		virtual ~animation_entry() {}
	protected:
		shash64 m_name;    /// string hash of name
		bool    m_looping; /// does the animation loop
		uint32  m_fps;     /// frames per second
		uint32  m_fstart;  /// start time (in frames)
		uint32  m_fend;    /// end time (in frames)
	};
#endif

}

#endif // NV_INTERFACE_ANIMATED_MESH_HH
