// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
* @file capi.hh
* @author Kornel Kisielewicz
* @brief C math API functions
*
* This header might be temporary
*/

// TODO: sanity checking with NV_DEBUG_ASSERT

#ifndef NV_BASE_CMATH_HH
#define NV_BASE_CMATH_HH

#include <nv/base/common.hh>
#include <math.h>

namespace nv
{

	namespace detail
	{
		template< typename T >
		inline T pow_int( T x, int y )
		{
			unsigned int n = static_cast<unsigned>( y >= 0 ? y : -y );
			for ( T z = static_cast<T>( 1 ); ; x *= x )
			{
				if ( ( n & 1 ) != 0 )
					z *= x;
				if ( ( n >>= 1 ) == 0 )
					return ( y < 0 ? static_cast<T>( 1 ) / z : z );
			}
		}

	}

	inline double abs( double x )
	{
		return ( ::fabs( x ) );
	}

	inline double pow( double x, int y )
	{
		return ( detail::pow_int( x, y ) );
	}

	inline float abs( float x )
	{
		return ( ::fabsf( x ) );
	}

	inline float acos( float x )
	{
		return ( ::acosf( x ) );
	}

	inline float cosh( float x )
	{
		return ( ::coshf( x ) );
	}

	inline float acosh( float x )
	{
		return ( ::acoshf( x ) );
	}

	inline float asin( float x )
	{
		return ( ::asinf( x ) );
	}

	inline float asinh( float x )
	{
		return ( ::asinhf( x ) );
	}

	inline float atan( float x )
	{
		return ( ::atanf( x ) );
	}

	inline float atanh( float x )
	{
		return ( ::atanhf( x ) );
	}

	inline float atan2( float y, float x )
	{
		return ( ::atan2f( y, x ) );
	}

	inline float cbrt( float x )
	{
		return ( ::cbrtf( x ) );
	}

	inline float ceil( float x )
	{
		return ( ::ceilf( x ) );
	}

	inline float cos( float x ) 
	{
		return ( ::cosf( x ) );
	}

	inline float erf( float x ) 
	{
		return ( ::erff( x ) );
	}

	inline float erfc( float x ) 
	{
		return ( ::erfcf( x ) );
	}

	inline float exp( float x ) 
	{
		return ( ::expf( x ) );
	}

	inline float exp2( float x ) 
	{
		return ( ::exp2f( x ) );
	}

	inline float expm1( float x ) 
	{
		return ( ::expm1f( x ) );
	}

	inline float fabs( float x ) 
	{
		return ( ::fabsf( x ) );
	}

	inline float fdim( float x, float y ) 
	{
		return ( ::fdimf( x, y ) );
	}

	inline float floor( float x ) 
	{
		return ( ::floorf( x ) );
	}

	inline float fma( float x, float y, float z ) 
	{
		return ( ::fmaf( x, y, z ) );
	}

	inline float fmax( float x, float y ) 
	{
		return ( ::fmaxf( x, y ) );
	}

	inline float fmin( float x, float y ) 
	{
		return ( ::fminf( x, y ) );
	}

	inline float fmodf( float x, float y ) 
	{
		return ( ::fmodf( x, y ) );
	}

	inline float frexp( float x, int* y ) 
	{
		return ( ::frexpf( x, y ) );
	}

	inline float hypot( float x, float y ) 
	{
		return ( ::hypotf( x, y ) );
	}

	inline int ilogb( float x ) 
	{
		return ( ::ilogbf( x ) );
	}

	inline float ldexp( float x, int y ) 
	{
		return ( ::ldexpf( x, y ) );
	}

	inline float lgamma( float x ) 
	{
		return ( ::lgammaf( x ) );
	}

	inline long long llrint( float x ) 
	{
		return ( ::llrintf( x ) );
	}

	inline long long llround( float x ) 
	{
		return ( ::llroundf( x ) );
	}

	inline float log( float x ) 
	{
		return ( ::logf( x ) );
	}

	inline float log10( float x ) 
	{
		return ( ::log10f( x ) );
	}

	inline float log1p( float x ) 
	{
		return ( ::log1pf( x ) );
	}

	inline float log2( float x ) 
	{
		return ( ::log2f( x ) );
	}

	inline float logb( float x ) 
	{
		return ( ::logbf( x ) );
	}

	inline long lrint( float x ) 
	{
		return ( ::lrintf( x ) );
	}

	inline long lround( float x ) 
	{
		return ( ::lroundf( x ) );
	}

	inline float modf( float x, float* y ) 
	{
		return ( ::modff( x, y ) );
	}

	inline float pow( float x, float y ) 
	{
		return ( ::powf( x, y ) );
	}

	inline float pow( float x, int y ) 
	{
		return ( detail::pow_int( x, y ) );
	}

	inline float remainder( float x, float y ) 
	{
		return ( ::remainderf( x, y ) );
	}

	inline float rint( float x ) 
	{
		return ( ::rintf( x ) );
	}

	inline float round( float x ) 
	{
		return ( ::roundf( x ) );
	}

	inline float sin( float x ) 
	{
		return ( ::sinf( x ) );
	}

	inline float sinh( float x ) 
	{
		return ( ::sinhf( x ) );
	}

	inline float sqrt( float x ) 
	{
		return ( ::sqrtf( x ) );
	}

	inline float tan( float x ) 
	{
		return ( ::tanf( x ) );
	}

	inline float tanh( float x ) 
	{
		return ( ::tanhf( x ) );
	}

	inline float tgamma( float x ) 
	{
		return ( ::tgammaf( x ) );
	}

	inline float trunc( float x ) 
	{
		return ( ::truncf( x ) );
	}

}

#endif // NV_BASE_CMATH_HH
