// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_LUA_MATH_HH
#define NV_LUA_MATH_HH

#include <nv/common.hh>
#include <nv/stl/math.hh>
#include <nv/lua/lua_state.hh>
#include <nv/lua/lua_values.hh>

namespace nv
{
	namespace lua
	{
		void register_math( lua::state* state );

		template<> struct pass_traits< vec2 >  : metatable_pass_traits< vec2 >  { static const char* metatable() { return "vec2"; } };
		template<> struct pass_traits< vec3 >  : metatable_pass_traits< vec3 >  { static const char* metatable() { return "vec3"; } };
		template<> struct pass_traits< vec4 >  : metatable_pass_traits< vec4 >  { static const char* metatable() { return "vec4"; } };
		template<> struct pass_traits< ivec2 > : metatable_pass_traits< ivec2 > { static const char* metatable() { return "ivec2"; } };
		template<> struct pass_traits< ivec3 > : metatable_pass_traits< ivec3 > { static const char* metatable() { return "ivec2"; } };
		template<> struct pass_traits< ivec4 > : metatable_pass_traits< ivec4 > { static const char* metatable() { return "ivec2"; } };

		namespace detail
		{
			template< typename T >
			bool is_vec( lua_State* L, int index )
			{
				return is_userdata( L, index, pass_traits<T>::metatable() );
			}

			template< typename T >
			T to_vec( lua_State* L, int index )
			{
				return pass_traits<T>::to( L, index );
			}

			template< typename T >
			T to_vec( lua_State* L, int index, const T& def )
			{
				return pass_traits<T>::to( L, index, def );
			}

			template< typename T >
			T* to_pvec( lua_State* L, int index )
			{
				return to_userdata<T>( L, index );
			}

			template< typename T >
			void push_vec( lua_State* L, const T& v )
			{
				pass_traits<T>::push( L, v );
			}

		}

	}

}


#endif // NV_LUA_MATH_HH
