// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file mesh_loader.hh
 * @author Kornel Kisielewicz
 * @brief mesh loader
 */

#ifndef NV_INTERFACE_MESH_LOADER_HH
#define NV_INTERFACE_MESH_LOADER_HH

#include <nv/common.hh>
#include <nv/core/transform.hh>
#include <nv/stl/string.hh>
#include <nv/gfx/animation.hh>
#include <nv/interface/mesh_data.hh>
#include <nv/stl/stream.hh>
#include <nv/stl/string_table.hh>

namespace nv 
{

	class mesh_loader
	{
	public:
		explicit mesh_loader( string_table* strings ) : m_strings( strings ) {}
		virtual ~mesh_loader() {}
		virtual bool load( stream& source ) = 0;
		virtual data_channel_set* release_mesh_data( size_t index, data_node_info& ) = 0;
		virtual size_t get_mesh_count() const = 0;
		virtual size_t get_nodes_data_count() const { return 0; }
		virtual mesh_nodes_data* release_mesh_nodes_data( size_t = 0 ) { return nullptr; }
		virtual data_node_list* release_data_node_list( size_t = 0 ) { return nullptr; }
		virtual bool is_animated( size_t = 0 ) { return false; }
	protected:
		inline shash64 make_name( const string_view& name )
		{
			return m_strings ? m_strings->insert( name ) : shash64( name.get_hash< uint64 >() );
		}
		string_table* m_strings;
	};

}

#endif // NV_INTERFACE_MESH_LOADER_HH

