// Copyright (C) 2015-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file mesh_manager.hh
 * @author Kornel Kisielewicz
 * @brief mesh_manager
 */

#ifndef NV_ENGINE_MESH_MANAGER_HH
#define NV_ENGINE_MESH_MANAGER_HH

#include <nv/common.hh>
#include <nv/core/resource.hh>
#include <nv/interface/mesh_data.hh>
#include <nv/gfx/skeleton_instance.hh>
#include <nv/engine/resource_system.hh>


namespace nv
{

	enum shader_type
	{
		NORMAL = 0,
		BONE = 1,
	};

	struct gpu_mesh
	{
		vertex_array va;
		uint32       count;
		shader_type  shader;
	};

	NV_RTTI_DECLARE_NAME( data_channel_set, "data_channel_set" )
	NV_RTTI_DECLARE_NAME( gpu_mesh, "gpu_mesh" )

	using mesh_manager = manual_resource_manager< data_channel_set >;

	class gpu_mesh_manager : public nv::manual_resource_manager< gpu_mesh >
	{
	public:
		gpu_mesh_manager( context* context, mesh_manager* mesh_manager )
			: m_context( context )
			, m_mesh_manager( mesh_manager ) {}
		virtual bool load_resource( const string_view& id );
		resource< gpu_mesh > load_resource( resource< data_channel_set > mesh );
	protected:
		virtual void release( gpu_mesh* m );
	private:
		context*      m_context;
		mesh_manager* m_mesh_manager;
	};

}

#endif // NV_ENGINE_MESH_MANAGER_HH
