// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#include "nv/gl/gl_window.hh"

#include "nv/core/logging.hh"
#include "nv/lib/gl.hh"

using namespace nv;

void gl_window::swap_buffers()
{
#if NV_PLATFORM == NV_WINDOWS
		::SwapBuffers( reinterpret_cast<HDC>( m_hwnd ) );
#else
	NV_ASSERT( false, "Native GL context currently only working on Windows!" );
#endif
}

gl_window::~gl_window()
{
	if ( m_context )
	{
#if NV_PLATFORM == NV_WINDOWS
			dynwglDeleteContext( reinterpret_cast<HGLRC>( m_context->get_native_handle() ) );
#endif
	}
	delete m_context;
	m_context = nullptr;
	delete m_input;
}

nv::gl_window::gl_window( device* dev, window_manager* wm, input* a_input, void* handle, void* dc )
	: m_device( dev ), m_width( 0 ), m_height( 0 ), m_handle( nullptr )
{
#if NV_PLATFORM == NV_WINDOWS
	m_input = a_input;

	m_handle = handle;

	// TODO: error checking
	HDC hdc = reinterpret_cast<HDC>( dc );

	const int wgl_attrib_list[] =
	{
		WGL_DRAW_TO_WINDOW_ARB, GL_TRUE,
		WGL_SUPPORT_OPENGL_ARB, GL_TRUE,
		WGL_ACCELERATION_ARB,   WGL_FULL_ACCELERATION_ARB,
		WGL_DOUBLE_BUFFER_ARB,  GL_TRUE,
		WGL_PIXEL_TYPE_ARB,     WGL_TYPE_RGBA_ARB,
		WGL_COLOR_BITS_ARB,     32,
		WGL_DEPTH_BITS_ARB,     24,
		WGL_STENCIL_BITS_ARB,   8,
		0, 0  //End
	};

	unsigned int num_formats;
	int pixel_format;
	PIXELFORMATDESCRIPTOR pfd;

	if ( FALSE == wglChoosePixelFormatARB(hdc, wgl_attrib_list, NULL, 1, &pixel_format, &num_formats) )
	{
		return;
	}

	if ( FALSE == SetPixelFormat(hdc, pixel_format, &pfd) )
	{
		//int err = GetLastError();
		return;
	}

	int attribs[] =
	{
		WGL_CONTEXT_MAJOR_VERSION_ARB,   3,
		WGL_CONTEXT_MINOR_VERSION_ARB,   1,
		WGL_CONTEXT_PROFILE_MASK_ARB,  WGL_CONTEXT_CORE_PROFILE_BIT_ARB, 
		//WGL_CONTEXT_PROFILE_MASK_ARB, WGL_CONTEXT_COMPATIBILITY_PROFILE_BIT_ARB,
		0, 0  //End
	};

	HGLRC ctx_handle;
	if ( 0 == (ctx_handle = wglCreateContextAttribsARB(hdc, 0, attribs) ) )
	{
		return;
	}

	if ( FALSE == dynwglMakeCurrent( hdc, ctx_handle ) )
	{
		return;
	}     

	load_gl_library( NV_GL_PATH, true );
	load_wgl_library( NV_GL_PATH, true );

	m_context = new gl_context( m_device, ctx_handle );
	// Doesn't work :/
// 	RECT rect;
// 	GetClientRect( (HWND)handle, &rect );
//  	m_width   = (uint16)rect.right;
//  	m_height  = (uint16)rect.bottom;
	m_handle  = wm->adopt_window( handle );
	m_hwnd    = ::GetDC( reinterpret_cast<HWND>( handle ) );
	m_context->set_viewport( nv::ivec4( 0, 0, 1, 1 ) );
#else
	NV_ASSERT( false, "Native GL context adoption not implemented for this platform!" );
#endif
}

