// Copyright (C) 2014-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#include "nv/gfx/debug_draw.hh"

#include "nv/interface/device.hh"
#include "nv/core/logging.hh"

static const char *nv_debug_draw_vertex_shader = R"(
#version 120
attribute vec3 nv_position;
attribute vec3 nv_color;
varying vec3 v_color;
uniform mat4 nv_m_mvp;
void main(void)
{
	gl_Position = nv_m_mvp * vec4 (nv_position, 1.0);
	v_color     = nv_color;
};
)";
static const char *nv_debug_draw_fragment_shader = R"(
#version 120
varying vec3 v_color;
void main(void)
{
	gl_FragColor = vec4( v_color, 1.0 );
}
)";

nv::debug_data::debug_data( context* a_context )
	: m_context( a_context ), m_program(), m_va()
{
	m_program = m_context->get_device()->create_program( nv_debug_draw_vertex_shader, nv_debug_draw_fragment_shader );
	m_buffer_size = 0;
}

void nv::debug_data::update()
{
	if ( !m_va.is_valid() || m_data.size() > m_buffer_size )
	{
		if ( m_va.is_valid() ) m_context->release( m_va );
		m_buffer_size = nv::max( m_data.size(), 4096U, m_buffer_size );
		m_va = m_context->create_vertex_array();
		m_vb = m_context->get_device()->create_buffer( VERTEX_BUFFER, nv::STREAM_DRAW, m_buffer_size * sizeof( debug_vtx ), m_data.data() );
		m_context->add_vertex_buffers< debug_vtx >( m_va, m_vb, true );
	}
	else
	{
		m_context->update( m_vb, m_data.data(), 0, m_data.size()* sizeof( debug_vtx ) );
	}
}

void nv::debug_data::reset()
{
	m_data.clear();
}

void nv::debug_data::push_line( const vec3& a, const vec3& b, const vec3& color )
{
	m_data.emplace_back( a, color );
	m_data.emplace_back( b, color );
}

void nv::debug_data::push_aabox( const vec3& a, const vec3& b, const vec3& color )
{
	vec3 corners[8] =
	{
		vec3( a.x, a.y, a.z ), vec3( b.x, a.y, a.z ), vec3( b.x, a.y, b.z ), vec3( a.x, a.y, b.z ),
		vec3( a.x, b.y, a.z ), vec3( b.x, b.y, a.z ), vec3( b.x, b.y, b.z ), vec3( a.x, b.y, b.z ),
	};

	push_line( corners[0], corners[1], color );
	push_line( corners[1], corners[2], color );
	push_line( corners[2], corners[3], color );
	push_line( corners[3], corners[0], color );
	push_line( corners[0], corners[4], color );
	push_line( corners[1], corners[5], color );
	push_line( corners[2], corners[6], color );
	push_line( corners[3], corners[7], color );
	push_line( corners[4], corners[5], color );
	push_line( corners[5], corners[6], color );
	push_line( corners[6], corners[7], color );
	push_line( corners[7], corners[4], color );
}

nv::debug_data::~debug_data()
{
	m_context->release( m_va );
	m_context->get_device()->release( m_program );
}
