// Copyright (C) 2015-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#include "nv/engine/image_manager.hh"

#include "nv/image/png_loader.hh"
#include "nv/io/c_file_system.hh"

using namespace nv;

bool image_manager::load_resource( const string_view& filename )
{
	png_loader loader;
	c_file_system fs;
	stream* file = fs.open( filename );
	image_data* result = loader.load( *file );
	delete file;
	add( filename, result );
	return result != nullptr;
}

