// Copyright (C) 2015-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file epsilon.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief epsilon math ops
 */

#ifndef NV_STL_MATH_EPSILON_HH
#define NV_STL_MATH_EPSILON_HH

#include <nv/stl/math/common.hh>
#include <nv/stl/math/relational.hh>

namespace nv
{

	namespace math
	{

		template < typename T, typename enable_if< is_floating_point<T>::value >::type* = nullptr >
		inline bool epsilon_equal( T a, T b, T epsilon )
		{
			return abs( a - b ) < epsilon;
		}

		template < typename T, typename enable_if< is_fp_vec<T>::value >::type* = nullptr >
		inline bool_vec_t< T > epsilon_equal( const T& a, const T& b, const T& epsilon )
		{
			return less_than( abs( a - b ), T( epsilon ) );
		}

		template < typename T, typename enable_if< is_fp_vec<T>::value >::type* = nullptr >
		inline bool_vec_t< T > epsilon_equal( const T& a, const T& b, value_type_t<T> epsilon )
		{
			return less_than( abs( a - b ), T( epsilon ) );
		}

		template < typename T, typename enable_if< is_floating_point<T>::value >::type* = nullptr >
		inline bool epsilon_not_equal( T a, T b, T epsilon )
		{
			return abs( a - b ) >= epsilon;
		}

		template < typename T, typename enable_if< is_fp_vec<T>::value >::type* = nullptr >
		inline bool_vec_t< T > epsilon_not_equal( const T& a, const T& b, const T& epsilon )
		{
			return greater_than_equal( abs( a - b ), T( epsilon ) );
		}

		template < typename T, typename enable_if< is_fp_vec<T>::value >::type* = nullptr >
		inline bool_vec_t< T > epsilon_not_equal( const T& a, const T& b, value_type_t<T> epsilon )
		{
			return greater_than_equal( abs( a - b ), T( epsilon ) );
		}


	}

}

#endif // NV_STL_MATH_EPSILON_HH
