// Copyright (C) 2011-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#include "nv/gfx/skeleton_instance.hh"

#include "nv/core/profiler.hh"

void nv::skeleton_binding::prepare( const mesh_nodes_data* node_data, const mesh_nodes_data* bone_data )
{
	if ( m_indices.empty() )
	{
		// TODO: either fixed size struct or static allocator
		hash_store< shash64, uint16 > bone_names;
		m_indices.resize( node_data->size() );
		
		for ( nv::uint16 bi = 0; bi < bone_data->size(); ++bi )
		{
			const data_channel_set* bone = ( *bone_data )[bi];
			bone_names[bone->get_name()] = bi;
		}

		for ( uint32 n = 0; n < node_data->size(); ++n )
		{
			const data_channel_set* node = ( *node_data )[n];
			sint16 bone_id = -1;

			auto bi = bone_names.find( node->get_name() );
			if ( bi != bone_names.end() )
			{
				bone_id = sint16( bi->second );
			}
			m_indices[n] = bone_id;

		}
		m_bone_count = bone_data->size();
	}

	if ( m_key.size() == 0 )
	{
		for ( uint32 n = 0; n < node_data->size(); ++n )
			if ( ( *node_data )[n]->size() > 0 )
			{
				m_key = ( *node_data )[n]->get_interpolation_key();
				break;
			}
	}


}

// void nv::skeleton_instance::animate_( const mesh_nodes_data* node_data, const skeleton_binding& binding, float frame )
// {
// 	if ( m_matrix.size() > 0 )
// 	{
// 		if ( node_data->is_flat() )
// 		{
// 			animate_flat( node_data, binding, frame );
// 		}
// 		else
// 		{
// 			for ( uint32 n = 0; n < node_data->size(); ++n )
// 				if ( ( *node_data )[n]->get_parent_id() == -1 )
// 					animate_rec( node_data, binding, frame, n, transform() );
// 		}
// 	}
// }
// 
// void nv::skeleton_instance::animate_rec( const mesh_nodes_data* node_data, const skeleton_binding& binding, float frame, uint32 id, const transform& parent )
// {
// 	// TODO: fix transforms, which are now embedded,
// 	//       see note in assimp_loader.cc:load_node
// 	const data_channel_set* node = ( *node_data )[id];
// 	transform node_mat( node->get_transform() );
// 
// 	if ( node->size() > 0 )
// 	{
// 		raw_channel_interpolator interpolator( node, binding.m_key );
// 		node_mat = interpolator.get< transform >( frame );
// 	}
// 
// 	transform global_mat = parent * node_mat;
// 
//  	sint16 bone_id = binding.m_indices[id];
//  	if ( bone_id >= 0 )
//  	{
//  		m_matrix[bone_id] = global_mat.extract() * binding.m_offsets[bone_id];
//  	}
// 
// 	for ( auto child : node_data->children( id ) )
// 	{
// 		animate_rec( node_data, binding, frame, child, global_mat );
// 	}
// }
// 
// void nv::skeleton_instance::animate_flat( const mesh_nodes_data* node_data, const skeleton_binding& binding, float frame ) 
// {
// 	for ( uint32 n = 0; n < node_data->size(); ++n )
// 		if ( binding.m_indices[n] >= 0 )
// 		{
// 			const data_channel_set* node = ( *node_data )[n];
// 			nv::mat4 node_mat( node->get_transform() );
// 
// 			if ( node->size() > 0 )
// 			{
// 				raw_channel_interpolator interpolator( node, binding.m_key );
// 				node_mat = interpolator.get< mat4 >( frame );
// 			}
// 			sint16 bone_id = binding.m_indices[n];
// 			m_matrix[bone_id] = node_mat * binding.m_offsets[bone_id];
// 		}
// }

void nv::skeleton_instance::assign( const skeleton_transforms& skeleton, const bone_transforms& bones )
{
	if ( bones.size() != m_matrix.size() ) 
		m_matrix.resize( bones.size() );
	const transform* transforms = skeleton.transforms();
	for ( uint32 n = 0; n < skeleton.size(); ++n )
		m_matrix[n] = transforms[n].extract() * bones.m_offsets[n];
}

void nv::skeleton_instance::assign( const bone_transforms& bones )
{
	if ( bones.size() != m_matrix.size() )
		m_matrix.resize( bones.size() );
}

void nv::skeleton_transforms::animate_rec( const mesh_nodes_data* node_data, const skeleton_binding& binding, float frame, uint32 id, const transform& parent )
{
	const data_channel_set* node = ( *node_data )[id];
	transform node_mat( node->get_transform() );

	if ( node->size() > 0 )
	{
		raw_channel_interpolator interpolator( node, binding.m_key );
		node_mat = interpolator.get< transform >( frame );
	}
	sint16 bone_id = binding.m_indices[id];
	transform global_mat = parent * node_mat;
	if ( bone_id >= 0 )
	{
		m_transforms[bone_id] = global_mat;
	}
	for ( auto child : node_data->children( id ) )
	{
		animate_rec( node_data, binding, frame, child, global_mat );
	}
}

void nv::bone_transforms::prepare( const mesh_nodes_data* bone_data )
{
	if ( m_offsets.empty() )
	{
		m_offsets.resize( bone_data->size() );

		for ( nv::uint16 bi = 0; bi < bone_data->size(); ++bi )
		{
			const data_channel_set* bone = ( *bone_data )[bi];
			m_offsets[bi] = bone->get_transform();
		}
	}
}
