// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_GFX_SKELETON_INSTANCE_HH
#define NV_GFX_SKELETON_INSTANCE_HH

#include <nv/common.hh>
#include <nv/stl/array.hh>
#include <nv/interface/context.hh>
#include <nv/interface/mesh_data.hh>

namespace nv
{

	class skeleton_binding
	{
	public:
		explicit skeleton_binding()
			: m_indices( nullptr )
			, m_offsets( nullptr )
		{
		}
		void prepare( const mesh_nodes_data* node_data, const mesh_nodes_data* bone_data );
		~skeleton_binding()
		{
			delete[] m_indices;
			delete[] m_offsets;
		}
	protected:
		sint16*                m_indices;
		mat4*                  m_offsets;
		data_descriptor        m_key;

		friend class skeleton_instance;
	};

	class skeleton_instance
	{
	public:
		explicit skeleton_instance( uint32 bone_count )
		{
			initialize( bone_count );
		}
		void initialize( uint32 bone_count )
		{
			if ( bone_count > m_transform.size() )
				m_transform.resize( bone_count );
		}
		const mat4* transforms() const { return m_transform.data(); }
		size_t size() const { return m_transform.size(); }

		void animate( const mesh_nodes_data* node_data, const skeleton_binding& binding, float frame );
	protected:
		void animate_rec( const mesh_nodes_data* node_data, const skeleton_binding& binding, float frame, uint32 id, const mat4& parent );
		void animate_flat( const mesh_nodes_data* node_data, const skeleton_binding& binding, float frame );

		dynamic_array< mat4 > m_transform;
};


}

#endif // NV_GFX_SKELETON_INSTANCE_HH
