NV_RUNTIME = NV_RUNTIME or "scrt"

project "nv-core"
	location (_ACTION.."/"..NV_RUNTIME)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/common.hh", "nv/base/**.hh", "nv/core/**.hh", "nv/stl/**.hh", "nv/interface/**.hh", "nv/detail/**.inc", "src/core/**.cc", "src/stl/**.cc"  }

project "nv-lib"
	location (_ACTION.."/"..NV_RUNTIME)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/lib/**.hh", "nv/lib/**.inl", "nv/lib/**.inc", "src/lib/**.cc" }
	links { "nv-core" }

project "nv-curses"
	location (_ACTION.."/"..NV_RUNTIME)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/curses/**.hh",  "src/curses/**.cc" }
	links { "nv-core", "nv-lib" }

project "nv-fmod"
	location (_ACTION.."/"..NV_RUNTIME)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/fmod/**.hh",    "src/fmod/**.cc" }
	links { "nv-core", "nv-lib" }

project "nv-sdl"
	location (_ACTION.."/"..NV_RUNTIME)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/sdl/**.hh",     "src/sdl/**.cc" }
	links { "nv-core", "nv-lib" }

project "nv-gl"
	location (_ACTION.."/"..NV_RUNTIME)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/gl/**.hh",     "src/gl/**.cc" }
	links { "nv-core", "nv-lib" }

project "nv-lua"
	location (_ACTION.."/"..NV_RUNTIME)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/lua/**.hh",     "src/lua/**.cc" }
	links { "nv-core", "nv-lib" }

project "nv-rogue"
	location (_ACTION.."/"..NV_RUNTIME)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/rogue/**.hh",     "src/rogue/**.cc" }
	links { "nv-core" }

project "nv-io"
	location (_ACTION.."/"..NV_RUNTIME)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/io/**.hh",     "src/io/**.cc" }
	links { "nv-core" }

project "nv-gfx"
	location (_ACTION.."/"..NV_RUNTIME)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/gfx/**.hh",  "src/gfx/**.cc" }
	links { "nv-core" }

project "nv-engine"
	location (_ACTION.."/"..NV_RUNTIME)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/engine/**.hh",  "src/engine/**.cc" }
	links { "nv-core", "nv-lib", "nv-lua" }

project "nv-formats"
	location (_ACTION.."/"..NV_RUNTIME)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/formats/**.hh", "src/formats/**.cc" }
	links { "nv-core", "nv-lib", "nv-io", "nv-gfx" }

project "nv-gui"
	location (_ACTION.."/"..NV_RUNTIME)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/gui/**.hh",     "src/gui/**.cc" }
	links { "nv-core", "nv-lib", "nv-io", "nv-gfx", "nv-lua" }

-- injection!
solution( solution().name )
	configuration "gmake"
		if _ACTION == "gmake-clang" then
			buildoptions { 
				"-std=c++11",
--                                -- on Mac OS X don't try to use old stdc++
--                                "-stdlib=libc++",
				"-Weverything",
				-- obviously we don't care about C++98 compatibility
				"-Wno-c++98-compat", 
				-- obviously we don't care about C++98 compatibility
				"-Wno-c++98-compat-pedantic",
				-- an evil one has to embrace
				"-Wno-float-equal",
				-- padding is a non-issue at the moment
				"-Wno-padded",
				-- we don't want to list all 128 keys of the key
				-- enum each time, right?
				"-Wno-switch-enum",
				-- yes, we need exit time destructors for libraries
				"-Wno-exit-time-destructors",
				-- same here
				"-Wno-global-constructors",
				-- no reasonable way to fix this with abstract 
				-- interfaces.
				"-Wno-weak-vtables",
				-- this can be reenabled if I find a nice solution
				"-Wno-cast-align",
			}
			--buildoptions { 
            --                    "-stdlib=libc++"
			--}
		else
			buildoptions { "-std=c++0x" }
		end
	configuration { "windows", "gmake" }
		linkoptions { "-mwindows" }

	configuration "linux"
		linkoptions { "-ldl" }

	configuration "vs*"
		defines { "_SECURE_SCL=0", "_CRT_SECURE_NO_WARNINGS=1" } --, "_ITERATOR_DEBUG_LEVEL=0", "_HAS_ITERATOR_DEBUGGING=0" }

if _ACTION == "gmake-clang" then
	premake.gcc.cc  = "clang"
	premake.gcc.cxx = "clang++"
	_ACTION = "gmake"
end

premake.action.add { 
	trigger = "gmake-clang", 
	description = "gmake file with clang overrides, needs 'make -R' to work",
}

if _ACTION == "clean" then
	for action in premake.action.each() do
		os.rmdir(action.trigger)
	end
end
