// Copyright (C) 2014-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file sdl_window.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief SDL Window implementation
 */

#ifndef NV_SDL_WINDOW_HH
#define NV_SDL_WINDOW_HH

#include <nv/interface/window.hh>
#include <nv/interface/input.hh>
#include <nv/gl/gl_context.hh>

namespace nv
{

	namespace sdl
	{
		class window : public nv::window
		{
		public:
			window( device* dev, uint16 width, uint16 height, bool fullscreen = false );
			virtual void set_title( const string_view& title );
			virtual void swap_buffers();

			virtual context* get_context()    { return m_context; }
			virtual device* get_device()      { return m_device; }
			virtual uint16 get_width() const  { return m_width; }
			virtual uint16 get_height() const { return m_height; }
			virtual string_view get_title() const { return m_title; }
			virtual void set_swap_control( bool enabled );
			virtual bool is_event_pending()            { return m_input->is_event_pending(); }
			virtual bool poll_event( io_event& event ) { return m_input->poll_event( event ); }

			virtual ~window();
		private:
			nv::input*  m_input;
			device*     m_device;
			uint16      m_width;
			uint16      m_height;
			string128   m_title;
			void*       m_handle;
			gl_context* m_context;
		};
	}

}

#endif // NV_SDL_WINDOW_HH
