#version 120

attribute vec2 nv_texcoord;
attribute vec3 nv_position;
attribute vec3 nv_normal;
attribute vec3 nv_tangent;

varying vec3 v_normal;
varying vec3 v_light_vector;
varying vec3 v_view_vector;
varying vec4 v_position;
varying vec2 v_texcoord;
varying mat3 v_m33_tangent;

uniform mat4 nv_m_model;
uniform mat4 nv_m_modelview;
uniform mat4 nv_m_projection;
uniform mat3 nv_m_normal;
uniform mat4 nv_m_mvp;
uniform float nv_interpolate;
uniform vec3 light_position;

void main(void) {
	vec4 vertex     = vec4( nv_position, 1.0 );
	vec3 eye_pos    = vec3( nv_m_modelview * vertex );
	v_normal        = normalize( nv_m_normal * nv_normal );
	v_light_vector  = vec3( normalize( light_position - eye_pos ) );
	v_view_vector   = vec3( normalize( -eye_pos ) );

	v_m33_tangent[0] = normalize(nv_m_normal * nv_tangent);
	v_m33_tangent[2] = v_normal;
	v_m33_tangent[1] = normalize(cross(v_m33_tangent[2], v_m33_tangent[0]));

	v_texcoord      = nv_texcoord;
	v_position      = nv_m_model * vertex;
	gl_Position     = nv_m_mvp * vertex;
}
