// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file common.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief STL common utility library
 */

#ifndef NV_STL_UTILITY_COMMON_HH
#define NV_STL_UTILITY_COMMON_HH

#include <nv/common.hh>
#include <nv/stl/type_traits/common.hh>

namespace nv
{
	template< typename T, typename U >
	void swap( T& x, U& y )
	{
		T t = move( x );
		x = move( y );
		y = move( t );
	}

	template < typename T >
	inline const T&	max( const T& a, const T& b )
	{
		return a < b ? b : a;
	}

	template < typename T >
	inline const T&	min( const T& a, const T& b )
	{
		return a > b ? b : a;
	}
}

#endif // NV_STL_UTILITY_COMMON_HH
