// Copyright (C) 2014-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file array.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief exception free array classes
 */

#ifndef NV_STL_ARRAY_HH
#define NV_STL_ARRAY_HH

#include <nv/stl/container/contiguous_storage.hh>
#include <nv/stl/container/fixed_storage.hh>
#include <nv/stl/container/sized_storage.hh>
#include <nv/stl/container/random_access.hh>

namespace nv
{

	template< typename T, size_t N >
	using fixed_static_storage = fixed_storage< static_storage< T, N >, N >;

	template< typename T, size_t N >
	using fixed_dynamic_storage = fixed_storage< dynamic_storage< T >, N >;

	template< typename T >
	using resizable_dynamic_storage = sized_storage< dynamic_storage< T > >;

	template< typename T, size_t N >
	using resizable_static_storage = sized_storage< static_storage< T, N > >;

	template< typename T, size_t N >
	using array =
		random_access < fixed_static_storage< T, N > >;
		
	template< typename T >
	using dynamic_array = 
		random_access < resizable_dynamic_storage< T > >;

}

#endif // NV_STL_ARRAY_HH
