// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_LUA_AREA_HH
#define NV_LUA_AREA_HH

#include <nv/common.hh>
#include <nv/core/position.hh>
#include <nv/lua/lua_math.hh>
#include <nv/lua/lua_state.hh>
#include <nv/lua/lua_values.hh>

namespace nv
{
	namespace lua
	{
		void register_area( lua_State* L );

		template<>
		struct pass_traits< rectangle > : metatable_pass_traits< rectangle >
		{
			static const char* metatable() { return "area"; }
		};

		namespace detail
		{
			inline bool is_area( lua_State* L, int index ) { return is_userdata( L, index, pass_traits<rectangle>::metatable() ); }
			inline rectangle to_area( lua_State* L, int index ) { return pass_traits<rectangle>::to( L, index ); }
			inline rectangle* to_parea( lua_State* L, int index ) { return to_userdata<rectangle>( L, index ); }
			inline void push_area( lua_State* L, const rectangle& v ) { pass_traits<rectangle>::push( L, v ); }

			inline bool is_coord( lua_State* L, int index ) { return is_vec<ivec2>( L, index ); }
			inline ivec2 to_coord( lua_State* L, int index ) { return to_vec<ivec2>( L, index ); }
			inline ivec2* to_pcoord( lua_State* L, int index ) { return to_pvec<ivec2>( L, index ); }
			inline void push_coord( lua_State* L, const ivec2& v ) { push_vec<ivec2>( L, v ); }
		}

	}

}

#endif // NV_LUA_AREA_HH
