// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_GFX_SKELETAL_MESH_HH
#define NV_GFX_SKELETAL_MESH_HH

#include <nv/common.hh>
#include <nv/interface/context.hh>
#include <nv/interface/animated_mesh.hh>
#include <nv/formats/nmd_loader.hh>
#include <nv/stl/array.hh>

namespace nv
{
	
 	class skeletal_animation_entry : public animation_entry
 	{
 	public:
 		skeletal_animation_entry( shash64 name, const mesh_nodes_data* anim, bool a_looping )
			: animation_entry( name, a_looping, anim->get_frame_rate(), 0.0f, anim->get_duration() )
			, m_node_data( anim )
		{
			initialize();
		}

		skeletal_animation_entry( shash64 name, const mesh_nodes_data* anim, float time_start, float time_end, bool a_looping )
			: animation_entry( name, a_looping, anim->get_frame_rate(), time_start, time_end )
			, m_node_data( anim )
		{
			initialize();
		}

		void prepare( const mesh_nodes_data* bones );
		void update_skeleton( mat4* tr, uint32 time ) const;
		~skeletal_animation_entry();
 	protected:
		void initialize();
		void animate_rec( mat4* data, float time, uint32 node_id, const mat4& parent_mat ) const;

	protected:
		const mesh_nodes_data* m_node_data;
		vector< uint32 >* m_children;
		sint16* m_bone_ids;
		mat4* m_offsets;
		bool m_prepared;
		data_descriptor m_interpolation_key;
 	};

	class skeletal_mesh : public animated_mesh
	{
	public:
		skeletal_mesh( context* a_context, const data_channel_set* a_mesh, const mesh_nodes_data* a_bone_data );
		virtual vertex_array get_vertex_array() const { return m_va; }
		virtual size_t get_index_count() const { return m_index_count; }
		virtual void run_animation( animation_entry* a_anim )
		{
			update_animation( a_anim, 0 );
		}
		virtual void update( program a_program );
		virtual void update_animation( animation_entry* a_anim, uint32 
			a_anim_time );
		virtual transform get_node_transform( uint32 node_id ) const;
		virtual mat4 get_node_matrix( uint32 node_id ) const;
		~skeletal_mesh()
		{
			m_context->release( m_va );
			delete[] m_transform;
		}
	protected:
		vertex_array m_va;
		context*     m_context;
		data_descriptor m_interpolation_key;
		const mesh_nodes_data* m_bone_data;
		uint32 m_index_count;
		mat4*  m_transform;
	};

} // namespace nv

#endif // NV_GFX_SKELETAL_MESH_HH
