// Copyright (C) 2015-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file common.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief math casts
 */

#ifndef NV_STL_MATH_CAST_HH
#define NV_STL_MATH_CAST_HH

#include <nv/stl/math/common.hh>
#include <nv/base/capi.hh>

namespace nv
{

	template < typename T >
	inline const T* data_cast( const math::tvec2< T >& v )
	{
		return &( v.x );
	}

	template < typename T >
	inline T* data_cast( math::tvec2< T >& v )
	{
		return &( v.x );
	}

	template < typename T >
	inline const T* data_cast( const math::tvec3< T >& v )
	{
		return &( v.x );
	}

	template < typename T >
	inline T* data_cast( math::tvec3< T >& v )
	{
		return &( v.x );
	}

	template < typename T >
	inline const T* data_cast( const math::tvec4< T >& v )
	{
		return &( v.x );
	}

	template < typename T >
	inline T* data_cast( math::tvec4< T >& v )
	{
		return &( v.x );
	}

	template < typename T >
	inline const T* data_cast( const math::tmat2< T >& m )
	{
		return &( m[0].x );
	}

	template < typename T >
	inline T* data_cast( math::tmat2< T >& m )
	{
		return &( m[0].x );
	}

	template < typename T >
	inline const T* data_cast( const math::tmat3< T >& m )
	{
		return &( m[0].x );
	}

	template < typename T >
	inline T* data_cast( math::tmat3< T >& m )
	{
		return &( m[0].x );
	}

	template < typename T >
	inline const T* data_cast( const math::tmat4< T >& m )
	{
		return &( m[0].x );
	}

	template < typename T >
	inline T* data_cast( math::tmat4< T >& m )
	{
		return &( m[0].x );
	}

	template < typename T >
	inline const T* data_cast( const math::tquat< T >& q )
	{
		return &( q[0] );
	}

	template < typename T >
	inline T* data_cast( math::tquat< T >& q )
	{
		return &( q[0] );
	}

	template < typename T >
	inline math::tvec2<T> make_vec2( const T * const ptr )
	{
		math::tvec2<T> result( math::ctor::uninitialize );
		nvmemcpy( data_cast( result ), ptr, sizeof( math::tvec2<T> ) );
		return result;
	}

	template < typename T >
	inline math::tvec3<T> make_vec3( const T * const ptr )
	{
		math::tvec3<T> result( math::ctor::uninitialize );
		nvmemcpy( data_cast( result ), ptr, sizeof( math::tvec3<T> ) );
		return result;
	}

	template < typename T >
	inline math::tvec4<T> make_vec4( const T * const ptr )
	{
		math::tvec4<T> result( math::ctor::uninitialize );
		nvmemcpy( data_cast( result ), ptr, sizeof( math::tvec4<T> ) );
		return result;
	}

	template < typename T >
	inline math::tmat2<T> make_mat2( const T * const ptr )
	{
		math::tmat2<T> result( math::ctor::uninitialize );
		nvmemcpy( data_cast( result ), ptr, sizeof( math::tmat2<T> ) );
		return result;
	}

	template < typename T >
	inline math::tmat3<T> make_mat3( const T * const ptr )
	{
		math::tmat3<T> result( math::ctor::uninitialize );
		nvmemcpy( data_cast( result ), ptr, sizeof( math::tmat3<T> ) );
		return result;
	}

	template < typename T >
	inline math::tmat4<T> make_mat4( const T * const ptr )
	{
		math::tmat4<T> result( math::ctor::uninitialize );
		nvmemcpy( data_cast( result ), ptr, sizeof( math::tmat4<T> ) );
		return result;
	}

	template < typename T >
	inline math::tquat<T> make_quat( const T * const ptr )
	{
		math::tquat<T> result( math::ctor::uninitialize );
		nvmemcpy( data_cast( result ), ptr, sizeof( math::tquat<T> ) );
		return result;
	}

}

#endif // NV_STL_MATH_COMMON_HH
