// Copyright (C) 2015-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
* @file exponential.hh
* @author Kornel Kisielewicz epyon@chaosforge.org
* @brief exponential math ops
*/

#ifndef NV_STL_MATH_EXPONENTIAL_HH
#define NV_STL_MATH_EXPONENTIAL_HH

#include <nv/stl/math/common.hh>
#include <nv/stl/math/constants.hh>

namespace nv
{

	namespace math
	{
		
		template < typename T, typename enable_if< is_fp_vec<T>::value >::type* = nullptr >
		inline T pow( const T& base, const T& exponent )
		{
			return detail::binary_functor<T>::call( pow, base, exponent );
		}

		template < typename T, typename enable_if< is_fp_vec<T>::value >::type* = nullptr >
		inline T exp( const T& x )
		{
			return detail::unary_functor<T>::call( exp, x );
		}

		template < typename T, typename enable_if< is_fp_vec<T>::value >::type* = nullptr >
		inline T log( const T& x )
		{
			return detail::unary_functor<T>::call( log, x );
		}

		template < typename T, typename enable_if< is_floating_point<T>::value >::type* = nullptr >
		inline T exp2( T x )
		{
			return exp( ln_two<T>() );
		}

		template < typename T, typename enable_if< is_fp_vec<T>::value >::type* = nullptr >
		inline T exp2( const T& x )
		{
			return detail::unary_functor<T>::call( exp2, x );
		}

		template < typename T, typename enable_if< is_fp_vec<T>::value >::type* = nullptr >
		inline T log2( const T& x )
		{
			return detail::unary_functor<T>::call( log2, x );
		}

		template < typename T, typename enable_if< is_fp_vec<T>::value >::type* = nullptr >
		inline T sqrt( const T& x )
		{
			return detail::unary_functor<T>::call( sqrt, x );
		}

		template < typename T, typename enable_if< is_fp<T>::value >::type* = nullptr >
		inline T inversesqrt( const T& x )
		{
			return static_cast<T>( 1 ) / sqrt( x );
		}

	}

}

#endif // NV_STL_MATH_EXPONENTIAL_HH
