// Copyright (C) 2015-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
* @file common.hh
* @author Kornel Kisielewicz epyon@chaosforge.org
* @brief math common
*/

#ifndef NV_STL_MATH_COMMON_HH
#define NV_STL_MATH_COMMON_HH

#include <nv/common.hh>

#if NV_COMPILER == NV_GNUC
#pragma GCC system_header
#elif NV_COMPILER == NV_CLANG
#pragma clang system_header
#endif

#include <nv/base/cmath.hh>
#include <glm/glm.hpp>
#include <glm/gtc/quaternion.hpp>
#include <glm/gtx/vector_angle.hpp>

namespace nv
{

	namespace math
	{
		using ::cos;
		using ::sin;
		using ::acos;
		using ::asin;
		using ::cosh;
		using ::sinh;
		using ::abs;
		using ::tan;
		using ::sqrt;
		using ::pow;
		using ::floor;
		using ::ceil;
#if 0
		template < typename T > using tvec2 = ::glm::detail::tvec2<T, glm::precision::highp>;
		template < typename T > using tvec3 = ::glm::detail::tvec3<T, glm::precision::highp>;
		template < typename T > using tvec4 = ::glm::detail::tvec4<T, glm::precision::highp>;
		template < typename T > using tmat2 = ::glm::detail::tmat2x2<T, glm::precision::highp>;
		template < typename T > using tmat3 = ::glm::detail::tmat3x3<T, glm::precision::highp>;
		template < typename T > using tmat4 = ::glm::detail::tmat4x4<T, glm::precision::highp>;
		template < typename T > using tquat = ::glm::detail::tmat4x4<T, glm::precision::highp>;
#else
		template < typename T > using tvec2 = ::glm::tvec2<T>;
		template < typename T > using tvec3 = ::glm::tvec3<T>;
		template < typename T > using tvec4 = ::glm::tvec4<T>;
		template < typename T > using tmat2 = ::glm::tmat2x2<T>;
		template < typename T > using tmat3 = ::glm::tmat3x3<T>;
		template < typename T > using tmat4 = ::glm::tmat4x4<T>;
		template < typename T > using tquat = ::glm::tquat<T,glm::highp>;
#endif

		typedef glm::quat quat;
		using glm::ctor;
	}

	typedef math::tvec2<sint8> i8vec2;
	typedef math::tvec3<sint8> i8vec3;
	typedef math::tvec4<sint8> i8vec4;

	typedef math::tvec2<sint16> i16vec2;
	typedef math::tvec3<sint16> i16vec3;
	typedef math::tvec4<sint16> i16vec4;

	typedef math::tvec2<uint8> u8vec2;
	typedef math::tvec3<uint8> u8vec3;
	typedef math::tvec4<uint8> u8vec4;

	typedef math::tvec2< float > vec2;
	typedef math::tvec3< float > vec3;
	typedef math::tvec4< float > vec4;

	typedef math::tvec2< int > ivec2;
	typedef math::tvec3< int > ivec3;
	typedef math::tvec4< int > ivec4;

	typedef math::tmat2< float > mat2;
	typedef math::tmat3< float > mat3;
	typedef math::tmat4< float > mat4;

	typedef math::quat quat;

}

#endif // NV_STL_MATH_COMMON_HH
