// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
* @file gui_ascii_renderer.hh
* @author Kornel Kisielewicz
* @brief GUI Renderer
*/

#ifndef NV_GUI_ASCII_RENDERER_HH
#define NV_GUI_ASCII_RENDERER_HH

#include <nv/common.hh>
#include <nv/core/position.hh>
#include <nv/stl/math.hh>
#include <nv/interface/terminal.hh>
#include <nv/gui/gui_renderer.hh>
#include <nv/gui/gui_common.hh>
#include <nv/gui/gui_style.hh>

namespace nv
{
	namespace gui
	{
		class ascii_renderer : public renderer
		{
		public:
			ascii_renderer( terminal* t );
			virtual void redraw( element* e, uint32 );
			virtual void draw( element* e );
			virtual void draw();
			virtual void on_style_change( element* e );
			virtual void on_hover_change( element* e );
			virtual void on_select_change( element* e );
			virtual rectangle get_area() const;
			virtual ~ascii_renderer();
		private:
			terminal* m_terminal;
		};

	} // namespace gui

} // namespace nv

#endif // NV_ASCII_RENDERER_HH
