// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#include "nv/gui/gui_style.hh"

#include "nv/gui/gui_environment.hh"
#include <nv/lua/lua_raw.hh>

using namespace nv;
using namespace nv::gui;

void style::load_style( const string_view& filename )
{
	NV_ASSERT_ALWAYS( m_env, "Environment not set in style!" );
	m_lua.do_file( filename );
}

bool style::get( element* e, const string_view& centry, const string_view& cselector, string128& s )
{
	lua::stack_guard guard( m_lua );
	if ( !resolve( e->m_id, e->m_class, cselector, centry, LUA_TSTRING ) ) return false;
	// TODO: create lua_tostringbuffer< size >
	s.assign( lua_tostring( m_lua, -1 ) );
	return true;
}

bool style::get( element* e, const string_view& centry, const string_view& cselector, vec4& vec )
{
	lua::stack_guard guard( m_lua );
	if ( !resolve( e->m_id, e->m_class, cselector, centry, LUA_TTABLE ) ) return false;
	vec = vec4();
	for ( int i = 0; i < 4; ++i )
	{
		lua_rawgeti( m_lua, -1, i+1 );
		if ( lua_isnil( m_lua, -1 ) ) return true;
		vec[i] = static_cast< float >( lua_tonumber( m_lua, -1 ) );
		lua_pop( m_lua, 1 );
	}
	return true;
}

bool style::get( element* e, const string_view& centry, const string_view& cselector, int& i )
{
	lua::stack_guard guard( m_lua );
	if ( !resolve( e->m_id, e->m_class, cselector, centry, LUA_TNUMBER ) ) return false;
	i = static_cast< int >( lua_tointeger( m_lua, -1 ) );
	return true;
}

bool style::get( element* e, const string_view& centry, const string_view& cselector, double& d )
{
	lua::stack_guard guard( m_lua );
	if ( !resolve( e->m_id, e->m_class, cselector, centry, LUA_TNUMBER ) ) return false;
	d = lua_tonumber( m_lua, -1 );
	return true;
}

style::~style()
{
}

bool style::find_entry( const string_view& cselector, const string_view& centry, int type )
{
	if ( lua_istable( m_lua, -1 ) )
	{
		if ( !cselector.empty() )
		{
			lua_getfield( m_lua, -1, cselector.data() );
			if ( lua_istable( m_lua, -1 ) )
			{
				lua_getfield( m_lua, -1, centry.data() );
				if ( lua_type( m_lua, -1 ) == type ) 
				{
					return true;
				}
				lua_pop( m_lua, 1 );
			}
			lua_pop( m_lua, 1 );
		}

		lua_getfield( m_lua, -1, centry.data() );
		if ( lua_type( m_lua, -1 ) == type ) return true;
	}
	return false;
}

bool style::resolve( shash64 cid, shash64 cclass, const string_view& cselector, const string_view& centry, int type )
{
	lua_getglobal( m_lua, "default" );
	int global = lua_gettop( m_lua );

	// check id
	string_view id( m_env->get_string( cid ) );
	if ( !id.empty() )
	{
		lua_getfield( m_lua, -1, id.data() );
		if ( find_entry( cselector, centry, type ) ) return true;
		lua_settop( m_lua, global );
	}
	// check class
	string_view klass( m_env->get_string( cclass ) );
	if ( !klass.empty() )
	{
		lua_getfield( m_lua, -1, klass.data() );
		if ( find_entry( cselector, centry, type ) ) return true;
		lua_settop( m_lua, global );
	}

	// check entry
	if ( find_entry( cselector, centry, type ) ) return true;
	return false;
}

void nv::gui::style::load_flags( element* e )
{
	lua::stack_guard guard( m_lua );
	lua_getglobal( m_lua, "default" );
	int global = lua_gettop( m_lua );

	// check id
	string_view id( m_env->get_string( e->m_id ) );
	if ( !id.empty() )
	{
		lua_getfield( m_lua, -1, id.data() );
		add_flags( e );
		lua_pop( m_lua, -1 );
	}
	// check class
	string_view klass( m_env->get_string( e->m_class ) );
	if ( !klass.empty() )
	{
		lua_getfield( m_lua, -1, klass.data() );
		add_flags( e );
		lua_pop( m_lua, -1 );
	}
	add_flags( e );
}

void nv::gui::style::add_flags( element* e )
{
	if ( lua_istable( m_lua, -1 ) )
	{
		lua_getfield( m_lua, -1, "hover" );
		if ( lua_istable( m_lua, -1 ) )
		{
			e->m_flags[DIRTY_HOVER] = true;
		}
		lua_pop( m_lua, 1 );

		lua_getfield( m_lua, -1, "selected" );
		if ( lua_istable( m_lua, -1 ) )
		{
			e->m_flags[DIRTY_SELECT] = true;
		}
		lua_pop( m_lua, 1 );
	}
}
