#define FMOD_VERSION    0x00044417

typedef int                       FMOD_BOOL;
typedef struct FMOD_SYSTEM        FMOD_SYSTEM;
typedef struct FMOD_SOUND         FMOD_SOUND;
typedef struct FMOD_CHANNEL       FMOD_CHANNEL;
typedef struct FMOD_CHANNELGROUP  FMOD_CHANNELGROUP;
typedef struct FMOD_SOUNDGROUP    FMOD_SOUNDGROUP;
typedef struct FMOD_REVERB        FMOD_REVERB;
typedef struct FMOD_DSP           FMOD_DSP;
typedef struct FMOD_DSPCONNECTION FMOD_DSPCONNECTION;
typedef struct FMOD_POLYGON		  FMOD_POLYGON;
typedef struct FMOD_GEOMETRY	  FMOD_GEOMETRY;
typedef struct FMOD_SYNCPOINT	  FMOD_SYNCPOINT;
typedef unsigned int              FMOD_MODE;
typedef unsigned int              FMOD_TIMEUNIT;
typedef unsigned int              FMOD_INITFLAGS;
typedef unsigned int              FMOD_CAPS;
typedef unsigned int              FMOD_DEBUGLEVEL;
typedef unsigned int              FMOD_MEMORY_TYPE;

typedef enum
{
    FMOD_OK,                        
    FMOD_ERR_ALREADYLOCKED,         
    FMOD_ERR_BADCOMMAND,            
    FMOD_ERR_CDDA_DRIVERS,          
    FMOD_ERR_CDDA_INIT,             
    FMOD_ERR_CDDA_INVALID_DEVICE,   
    FMOD_ERR_CDDA_NOAUDIO,          
    FMOD_ERR_CDDA_NODEVICES,         
    FMOD_ERR_CDDA_NODISC,           
    FMOD_ERR_CDDA_READ,             
    FMOD_ERR_CHANNEL_ALLOC,         
    FMOD_ERR_CHANNEL_STOLEN,        
    FMOD_ERR_COM,                   
    FMOD_ERR_DMA,                   
    FMOD_ERR_DSP_CONNECTION,        
    FMOD_ERR_DSP_FORMAT,            
    FMOD_ERR_DSP_NOTFOUND,          
    FMOD_ERR_DSP_RUNNING,           
    FMOD_ERR_DSP_TOOMANYCONNECTIONS,
    FMOD_ERR_FILE_BAD,              
    FMOD_ERR_FILE_COULDNOTSEEK,     
    FMOD_ERR_FILE_DISKEJECTED,      
    FMOD_ERR_FILE_EOF,              
    FMOD_ERR_FILE_NOTFOUND,         
    FMOD_ERR_FILE_UNWANTED,         
    FMOD_ERR_FORMAT,                
    FMOD_ERR_HTTP,                  
    FMOD_ERR_HTTP_ACCESS,           
    FMOD_ERR_HTTP_PROXY_AUTH,       
    FMOD_ERR_HTTP_SERVER_ERROR,     
    FMOD_ERR_HTTP_TIMEOUT,          
    FMOD_ERR_INITIALIZATION,        
    FMOD_ERR_INITIALIZED,           
    FMOD_ERR_INTERNAL,              
    FMOD_ERR_INVALID_ADDRESS,       
    FMOD_ERR_INVALID_FLOAT,         
    FMOD_ERR_INVALID_HANDLE,        
    FMOD_ERR_INVALID_PARAM,         
    FMOD_ERR_INVALID_POSITION,      
    FMOD_ERR_INVALID_SPEAKER,       
    FMOD_ERR_INVALID_SYNCPOINT,     
    FMOD_ERR_INVALID_VECTOR,        
    FMOD_ERR_MAXAUDIBLE,            
    FMOD_ERR_MEMORY,                
    FMOD_ERR_MEMORY_CANTPOINT,      
    FMOD_ERR_MEMORY_SRAM,           
    FMOD_ERR_NEEDS2D,               
    FMOD_ERR_NEEDS3D,               
    FMOD_ERR_NEEDSHARDWARE,         
    FMOD_ERR_NEEDSSOFTWARE,         
    FMOD_ERR_NET_CONNECT,           
    FMOD_ERR_NET_SOCKET_ERROR,      
    FMOD_ERR_NET_URL,               
    FMOD_ERR_NET_WOULD_BLOCK,       
    FMOD_ERR_NOTREADY,              
    FMOD_ERR_OUTPUT_ALLOCATED,      
    FMOD_ERR_OUTPUT_CREATEBUFFER,   
    FMOD_ERR_OUTPUT_DRIVERCALL,     
    FMOD_ERR_OUTPUT_ENUMERATION,    
    FMOD_ERR_OUTPUT_FORMAT,         
    FMOD_ERR_OUTPUT_INIT,           
    FMOD_ERR_OUTPUT_NOHARDWARE,     
    FMOD_ERR_OUTPUT_NOSOFTWARE,     
    FMOD_ERR_PAN,                   
    FMOD_ERR_PLUGIN,                
    FMOD_ERR_PLUGIN_INSTANCES,      
    FMOD_ERR_PLUGIN_MISSING,        
    FMOD_ERR_PLUGIN_RESOURCE,       
    FMOD_ERR_PRELOADED,             
    FMOD_ERR_PROGRAMMERSOUND,       
    FMOD_ERR_RECORD,                
    FMOD_ERR_REVERB_INSTANCE,       
    FMOD_ERR_SUBSOUND_ALLOCATED,    
    FMOD_ERR_SUBSOUND_CANTMOVE,     
    FMOD_ERR_SUBSOUND_MODE,         
    FMOD_ERR_SUBSOUNDS,             
    FMOD_ERR_TAGNOTFOUND,           
    FMOD_ERR_TOOMANYCHANNELS,       
    FMOD_ERR_UNIMPLEMENTED,         
    FMOD_ERR_UNINITIALIZED,         
    FMOD_ERR_UNSUPPORTED,           
    FMOD_ERR_UPDATE,                
    FMOD_ERR_VERSION,               

    FMOD_ERR_EVENT_FAILED,          
    FMOD_ERR_EVENT_INFOONLY,        
    FMOD_ERR_EVENT_INTERNAL,        
    FMOD_ERR_EVENT_MAXSTREAMS,      
    FMOD_ERR_EVENT_MISMATCH,        
    FMOD_ERR_EVENT_NAMECONFLICT,    
    FMOD_ERR_EVENT_NOTFOUND,        
    FMOD_ERR_EVENT_NEEDSSIMPLE,     
    FMOD_ERR_EVENT_GUIDCONFLICT,    
    FMOD_ERR_EVENT_ALREADY_LOADED,  

    FMOD_ERR_MUSIC_UNINITIALIZED,   
    FMOD_ERR_MUSIC_NOTFOUND,        
    FMOD_ERR_MUSIC_NOCALLBACK,      

    FMOD_RESULT_FORCEINT = 65536    
} FMOD_RESULT;

typedef struct
{
	float x;        
    float y;        
    float z;        
} FMOD_VECTOR;

typedef struct
{
    unsigned int   Data1;       
    unsigned short Data2;       
    unsigned short Data3;       
    unsigned char  Data4[8];    
} FMOD_GUID;

typedef struct
{
    void           *handle;         
    unsigned int    offset;         
    unsigned int    sizebytes;      
    int             priority;       

    void           *buffer;         
    unsigned int    bytesread;      
    FMOD_RESULT     result;         

    void           *userdata;       
} FMOD_ASYNCREADINFO;

typedef enum
{
    FMOD_OUTPUTTYPE_AUTODETECT,      
                                     
    FMOD_OUTPUTTYPE_UNKNOWN,         
    FMOD_OUTPUTTYPE_NOSOUND,         
    FMOD_OUTPUTTYPE_WAVWRITER,       
    FMOD_OUTPUTTYPE_NOSOUND_NRT,     
    FMOD_OUTPUTTYPE_WAVWRITER_NRT,   
                                     
    FMOD_OUTPUTTYPE_DSOUND,          
    FMOD_OUTPUTTYPE_WINMM,           
    FMOD_OUTPUTTYPE_WASAPI,          
    FMOD_OUTPUTTYPE_ASIO,            
    FMOD_OUTPUTTYPE_OSS,             
    FMOD_OUTPUTTYPE_ALSA,            
    FMOD_OUTPUTTYPE_ESD,             
    FMOD_OUTPUTTYPE_PULSEAUDIO,      
    FMOD_OUTPUTTYPE_COREAUDIO,       
    FMOD_OUTPUTTYPE_XBOX360,         
    FMOD_OUTPUTTYPE_PSP,             
    FMOD_OUTPUTTYPE_PS3,             
    FMOD_OUTPUTTYPE_NGP,             
	FMOD_OUTPUTTYPE_WII,			 
    FMOD_OUTPUTTYPE_3DS,             
    FMOD_OUTPUTTYPE_AUDIOTRACK,      
    FMOD_OUTPUTTYPE_OPENSL,             
    FMOD_OUTPUTTYPE_NACL,            
    FMOD_OUTPUTTYPE_WIIU,            
	FMOD_OUTPUTTYPE_ASOUND,		 	 
    FMOD_OUTPUTTYPE_AUDIOOUT,        
    FMOD_OUTPUTTYPE_XAUDIO,          

    FMOD_OUTPUTTYPE_MAX,             
    FMOD_OUTPUTTYPE_FORCEINT = 65536 
} FMOD_OUTPUTTYPE;

#define FMOD_CAPS_NONE                   0x00000000  
#define FMOD_CAPS_HARDWARE               0x00000001  
#define FMOD_CAPS_HARDWARE_EMULATED      0x00000002  
#define FMOD_CAPS_OUTPUT_MULTICHANNEL    0x00000004  
#define FMOD_CAPS_OUTPUT_FORMAT_PCM8     0x00000008  
#define FMOD_CAPS_OUTPUT_FORMAT_PCM16    0x00000010  
#define FMOD_CAPS_OUTPUT_FORMAT_PCM24    0x00000020  
#define FMOD_CAPS_OUTPUT_FORMAT_PCM32    0x00000040  
#define FMOD_CAPS_OUTPUT_FORMAT_PCMFLOAT 0x00000080  
#define FMOD_CAPS_REVERB_LIMITED         0x00002000  
#define FMOD_CAPS_LOOPBACK               0x00004000  

#define FMOD_DEBUG_LEVEL_NONE           0x00000000
#define FMOD_DEBUG_LEVEL_LOG            0x00000001      
#define FMOD_DEBUG_LEVEL_ERROR          0x00000002      
#define FMOD_DEBUG_LEVEL_WARNING        0x00000004      
#define FMOD_DEBUG_LEVEL_HINT           0x00000008      
#define FMOD_DEBUG_LEVEL_ALL            0x000000FF    
#define FMOD_DEBUG_TYPE_MEMORY          0x00000100      
#define FMOD_DEBUG_TYPE_THREAD          0x00000200      
#define FMOD_DEBUG_TYPE_FILE            0x00000400      
#define FMOD_DEBUG_TYPE_NET             0x00000800      
#define FMOD_DEBUG_TYPE_EVENT           0x00001000      
#define FMOD_DEBUG_TYPE_ALL             0x0000FFFF                      
#define FMOD_DEBUG_DISPLAY_TIMESTAMPS   0x01000000      
#define FMOD_DEBUG_DISPLAY_LINENUMBERS  0x02000000      
#define FMOD_DEBUG_DISPLAY_COMPRESS     0x04000000      
#define FMOD_DEBUG_DISPLAY_THREAD       0x08000000      
#define FMOD_DEBUG_DISPLAY_ALL          0x0F000000
#define FMOD_DEBUG_ALL                  0xFFFFFFFF

#define FMOD_MEMORY_NORMAL             0x00000000       
#define FMOD_MEMORY_STREAM_FILE        0x00000001       
#define FMOD_MEMORY_STREAM_DECODE      0x00000002       
#define FMOD_MEMORY_SAMPLEDATA         0x00000004       
#define FMOD_MEMORY_DSP_OUTPUTBUFFER   0x00000008       
#define FMOD_MEMORY_XBOX360_PHYSICAL   0x00100000       
#define FMOD_MEMORY_PERSISTENT         0x00200000       
#define FMOD_MEMORY_SECONDARY          0x00400000       
#define FMOD_MEMORY_ALL                0xFFFFFFFF

typedef enum
{
    FMOD_SPEAKERMODE_RAW,              
    FMOD_SPEAKERMODE_MONO,             
    FMOD_SPEAKERMODE_STEREO,           
    FMOD_SPEAKERMODE_QUAD,             
    FMOD_SPEAKERMODE_SURROUND,         
    FMOD_SPEAKERMODE_5POINT1,          
    FMOD_SPEAKERMODE_7POINT1,          
    
    FMOD_SPEAKERMODE_SRS5_1_MATRIX,    
    FMOD_SPEAKERMODE_DOLBY5_1_MATRIX,  
    FMOD_SPEAKERMODE_MYEARS,           

    FMOD_SPEAKERMODE_MAX,              
    FMOD_SPEAKERMODE_FORCEINT = 65536  
} FMOD_SPEAKERMODE;

typedef enum
{
    FMOD_SPEAKER_FRONT_LEFT,
    FMOD_SPEAKER_FRONT_RIGHT,
    FMOD_SPEAKER_FRONT_CENTER,
    FMOD_SPEAKER_LOW_FREQUENCY,
    FMOD_SPEAKER_BACK_LEFT,
    FMOD_SPEAKER_BACK_RIGHT,
    FMOD_SPEAKER_SIDE_LEFT,
    FMOD_SPEAKER_SIDE_RIGHT,
    
    FMOD_SPEAKER_MAX,                                       
    FMOD_SPEAKER_MONO        = FMOD_SPEAKER_FRONT_LEFT,     
    FMOD_SPEAKER_NULL        = 65535,                       
    FMOD_SPEAKER_SBL         = FMOD_SPEAKER_SIDE_LEFT,      
    FMOD_SPEAKER_SBR         = FMOD_SPEAKER_SIDE_RIGHT,     
    FMOD_SPEAKER_FORCEINT    = 65536                        
} FMOD_SPEAKER;

typedef enum
{
    FMOD_PLUGINTYPE_OUTPUT,          
    FMOD_PLUGINTYPE_CODEC,           
    FMOD_PLUGINTYPE_DSP,             

    FMOD_PLUGINTYPE_MAX,             
    FMOD_PLUGINTYPE_FORCEINT = 65536 
} FMOD_PLUGINTYPE;

#define FMOD_INIT_NORMAL                     0x00000000 
#define FMOD_INIT_STREAM_FROM_UPDATE         0x00000001 
#define FMOD_INIT_3D_RIGHTHANDED             0x00000002 
#define FMOD_INIT_SOFTWARE_DISABLE           0x00000004 
#define FMOD_INIT_OCCLUSION_LOWPASS          0x00000008 
#define FMOD_INIT_HRTF_LOWPASS               0x00000010 
#define FMOD_INIT_DISTANCE_FILTERING         0x00000200 
#define FMOD_INIT_REVERB_PREALLOCBUFFERS     0x00000040 
#define FMOD_INIT_ENABLE_PROFILE             0x00000020 
#define FMOD_INIT_VOL0_BECOMES_VIRTUAL       0x00000080 
#define FMOD_INIT_WASAPI_EXCLUSIVE           0x00000100 
#define FMOD_INIT_PS3_PREFERDTS              0x00800000 
#define FMOD_INIT_PS3_FORCE2CHLPCM           0x01000000 
#define FMOD_INIT_DISABLEDOLBY               0x00100000 
#define FMOD_INIT_SYSTEM_MUSICMUTENOTPAUSE   0x00200000 
#define FMOD_INIT_SYNCMIXERWITHUPDATE        0x00400000 
#define FMOD_INIT_GEOMETRY_USECLOSEST        0x04000000 
#define FMOD_INIT_DISABLE_MYEARS_AUTODETECT  0x08000000 
#define FMOD_INIT_PS3_DISABLEDTS             0x10000000 
#define FMOD_INIT_PS3_DISABLEDOLBYDIGITAL    0x20000000 

typedef enum
{
    FMOD_SOUND_TYPE_UNKNOWN,         
    FMOD_SOUND_TYPE_AIFF,            
    FMOD_SOUND_TYPE_ASF,             
    FMOD_SOUND_TYPE_AT3,             
    FMOD_SOUND_TYPE_CDDA,            
    FMOD_SOUND_TYPE_DLS,             
    FMOD_SOUND_TYPE_FLAC,            
    FMOD_SOUND_TYPE_FSB,             
    FMOD_SOUND_TYPE_GCADPCM,         
    FMOD_SOUND_TYPE_IT,              
    FMOD_SOUND_TYPE_MIDI,            
    FMOD_SOUND_TYPE_MOD,             
    FMOD_SOUND_TYPE_MPEG,            
    FMOD_SOUND_TYPE_OGGVORBIS,       
    FMOD_SOUND_TYPE_PLAYLIST,        
    FMOD_SOUND_TYPE_RAW,             
    FMOD_SOUND_TYPE_S3M,             
    FMOD_SOUND_TYPE_SF2,             
    FMOD_SOUND_TYPE_USER,            
    FMOD_SOUND_TYPE_WAV,             
    FMOD_SOUND_TYPE_XM,              
    FMOD_SOUND_TYPE_XMA,             
    FMOD_SOUND_TYPE_VAG,             
    FMOD_SOUND_TYPE_AUDIOQUEUE,      
    FMOD_SOUND_TYPE_XWMA,            
    FMOD_SOUND_TYPE_BCWAV,           
    FMOD_SOUND_TYPE_AT9,             
    FMOD_SOUND_TYPE_VORBIS,          
    FMOD_SOUND_TYPE_MEDIA_FOUNDATION,

    FMOD_SOUND_TYPE_MAX,             
    FMOD_SOUND_TYPE_FORCEINT = 65536 
} FMOD_SOUND_TYPE;

typedef enum
{
    FMOD_SOUND_FORMAT_NONE,             
    FMOD_SOUND_FORMAT_PCM8,             
    FMOD_SOUND_FORMAT_PCM16,            
    FMOD_SOUND_FORMAT_PCM24,            
    FMOD_SOUND_FORMAT_PCM32,            
    FMOD_SOUND_FORMAT_PCMFLOAT,         
    FMOD_SOUND_FORMAT_GCADPCM,          
    FMOD_SOUND_FORMAT_IMAADPCM,         
    FMOD_SOUND_FORMAT_VAG,              
    FMOD_SOUND_FORMAT_HEVAG,            
    FMOD_SOUND_FORMAT_XMA,              
    FMOD_SOUND_FORMAT_MPEG,             
    FMOD_SOUND_FORMAT_CELT,             
    FMOD_SOUND_FORMAT_AT9,              
    FMOD_SOUND_FORMAT_XWMA,             
    FMOD_SOUND_FORMAT_VORBIS,           

    FMOD_SOUND_FORMAT_MAX,                 
    FMOD_SOUND_FORMAT_FORCEINT = 65536  
} FMOD_SOUND_FORMAT;

#define FMOD_DEFAULT                   0x00000000  
#define FMOD_LOOP_OFF                  0x00000001  
#define FMOD_LOOP_NORMAL               0x00000002  
#define FMOD_LOOP_BIDI                 0x00000004  
#define FMOD_2D                        0x00000008  
#define FMOD_3D                        0x00000010  
#define FMOD_HARDWARE                  0x00000020  
#define FMOD_SOFTWARE                  0x00000040  
#define FMOD_CREATESTREAM              0x00000080  
#define FMOD_CREATESAMPLE              0x00000100  
#define FMOD_CREATECOMPRESSEDSAMPLE    0x00000200  
#define FMOD_OPENUSER                  0x00000400  
#define FMOD_OPENMEMORY                0x00000800  
#define FMOD_OPENMEMORY_POINT          0x10000000  
#define FMOD_OPENRAW                   0x00001000  
#define FMOD_OPENONLY                  0x00002000  
#define FMOD_ACCURATETIME              0x00004000  
#define FMOD_MPEGSEARCH                0x00008000  
#define FMOD_NONBLOCKING               0x00010000  
#define FMOD_UNIQUE                    0x00020000  
#define FMOD_3D_HEADRELATIVE           0x00040000  
#define FMOD_3D_WORLDRELATIVE          0x00080000  
#define FMOD_3D_INVERSEROLLOFF         0x00100000  
#define FMOD_3D_LINEARROLLOFF          0x00200000  
#define FMOD_3D_LINEARSQUAREROLLOFF    0x00400000  
#define FMOD_3D_CUSTOMROLLOFF          0x04000000  
#define FMOD_3D_IGNOREGEOMETRY         0x40000000  
#define FMOD_UNICODE                   0x01000000  
#define FMOD_IGNORETAGS                0x02000000  
#define FMOD_LOWMEM                    0x08000000  
#define FMOD_LOADSECONDARYRAM          0x20000000  
#define FMOD_VIRTUAL_PLAYFROMSTART     0x80000000  

typedef enum
{
    FMOD_OPENSTATE_READY = 0,       
    FMOD_OPENSTATE_LOADING,         
    FMOD_OPENSTATE_ERROR,           
    FMOD_OPENSTATE_CONNECTING,      
    FMOD_OPENSTATE_BUFFERING,       
    FMOD_OPENSTATE_SEEKING,         
    FMOD_OPENSTATE_PLAYING,         
    FMOD_OPENSTATE_SETPOSITION,     

    FMOD_OPENSTATE_MAX,             
    FMOD_OPENSTATE_FORCEINT = 65536 
} FMOD_OPENSTATE;

typedef enum 
{
    FMOD_SOUNDGROUP_BEHAVIOR_FAIL,              
    FMOD_SOUNDGROUP_BEHAVIOR_MUTE,              
    FMOD_SOUNDGROUP_BEHAVIOR_STEALLOWEST,       

    FMOD_SOUNDGROUP_BEHAVIOR_MAX,               
    FMOD_SOUNDGROUP_BEHAVIOR_FORCEINT = 65536   
} FMOD_SOUNDGROUP_BEHAVIOR;

typedef enum
{
    FMOD_CHANNEL_CALLBACKTYPE_END,                  
    FMOD_CHANNEL_CALLBACKTYPE_VIRTUALVOICE,         
    FMOD_CHANNEL_CALLBACKTYPE_SYNCPOINT,            
    FMOD_CHANNEL_CALLBACKTYPE_OCCLUSION,            

    FMOD_CHANNEL_CALLBACKTYPE_MAX,                  
    FMOD_CHANNEL_CALLBACKTYPE_FORCEINT = 65536      
} FMOD_CHANNEL_CALLBACKTYPE;

typedef enum
{
    FMOD_SYSTEM_CALLBACKTYPE_DEVICELISTCHANGED,         
    FMOD_SYSTEM_CALLBACKTYPE_DEVICELOST,                
    FMOD_SYSTEM_CALLBACKTYPE_MEMORYALLOCATIONFAILED,    
    FMOD_SYSTEM_CALLBACKTYPE_THREADCREATED,             
    FMOD_SYSTEM_CALLBACKTYPE_BADDSPCONNECTION,          
    FMOD_SYSTEM_CALLBACKTYPE_BADDSPLEVEL,               

    FMOD_SYSTEM_CALLBACKTYPE_MAX,                       
    FMOD_SYSTEM_CALLBACKTYPE_FORCEINT = 65536           
} FMOD_SYSTEM_CALLBACKTYPE;

typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_SYSTEM_CALLBACK)       (FMOD_SYSTEM *system, FMOD_SYSTEM_CALLBACKTYPE type, void *commanddata1, void *commanddata2);

typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_CHANNEL_CALLBACK)      (FMOD_CHANNEL *channel, FMOD_CHANNEL_CALLBACKTYPE type, void *commanddata1, void *commanddata2);

typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_SOUND_NONBLOCKCALLBACK)(FMOD_SOUND *sound, FMOD_RESULT result);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_SOUND_PCMREADCALLBACK)(FMOD_SOUND *sound, void *data, unsigned int datalen);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_SOUND_PCMSETPOSCALLBACK)(FMOD_SOUND *sound, int subsound, unsigned int position, FMOD_TIMEUNIT postype);

typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_FILE_OPENCALLBACK)     (const char *name, int unicode, unsigned int *filesize, void **handle, void **userdata);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_FILE_CLOSECALLBACK)    (void *handle, void *userdata);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_FILE_READCALLBACK)     (void *handle, void *buffer, unsigned int sizebytes, unsigned int *bytesread, void *userdata);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_FILE_SEEKCALLBACK)     (void *handle, unsigned int pos, void *userdata);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_FILE_ASYNCREADCALLBACK)(FMOD_ASYNCREADINFO *info, void *userdata);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_FILE_ASYNCCANCELCALLBACK)(void *handle, void *userdata);

typedef void *      (NV_FMOD_APIENTRY *FMOD_MEMORY_ALLOCCALLBACK)  (unsigned int size, FMOD_MEMORY_TYPE type, const char *sourcestr);
typedef void *      (NV_FMOD_APIENTRY *FMOD_MEMORY_REALLOCCALLBACK)(void *ptr, unsigned int size, FMOD_MEMORY_TYPE type, const char *sourcestr);
typedef void        (NV_FMOD_APIENTRY *FMOD_MEMORY_FREECALLBACK)   (void *ptr, FMOD_MEMORY_TYPE type, const char *sourcestr);

typedef float       (NV_FMOD_APIENTRY *FMOD_3D_ROLLOFFCALLBACK)    (FMOD_CHANNEL *channel, float distance);

typedef enum
{
    FMOD_DSP_FFT_WINDOW_RECT,            
    FMOD_DSP_FFT_WINDOW_TRIANGLE,        
    FMOD_DSP_FFT_WINDOW_HAMMING,         
    FMOD_DSP_FFT_WINDOW_HANNING,         
    FMOD_DSP_FFT_WINDOW_BLACKMAN,        
    FMOD_DSP_FFT_WINDOW_BLACKMANHARRIS,  
    
    FMOD_DSP_FFT_WINDOW_MAX,             
    FMOD_DSP_FFT_WINDOW_FORCEINT = 65536 
} FMOD_DSP_FFT_WINDOW;

typedef enum
{
    FMOD_DSP_RESAMPLER_NOINTERP,        
    FMOD_DSP_RESAMPLER_LINEAR,          
    FMOD_DSP_RESAMPLER_CUBIC,           
    FMOD_DSP_RESAMPLER_SPLINE,          

    FMOD_DSP_RESAMPLER_MAX,             
    FMOD_DSP_RESAMPLER_FORCEINT = 65536 
} FMOD_DSP_RESAMPLER;

typedef enum
{
    FMOD_TAGTYPE_UNKNOWN = 0,
    FMOD_TAGTYPE_ID3V1,
    FMOD_TAGTYPE_ID3V2,
    FMOD_TAGTYPE_VORBISCOMMENT,
    FMOD_TAGTYPE_SHOUTCAST,
    FMOD_TAGTYPE_ICECAST,
    FMOD_TAGTYPE_ASF,
    FMOD_TAGTYPE_MIDI,
    FMOD_TAGTYPE_PLAYLIST,
    FMOD_TAGTYPE_FMOD,
    FMOD_TAGTYPE_USER,

    FMOD_TAGTYPE_MAX,               
    FMOD_TAGTYPE_FORCEINT = 65536   
} FMOD_TAGTYPE;

typedef enum
{
    FMOD_TAGDATATYPE_BINARY = 0,
    FMOD_TAGDATATYPE_INT,
    FMOD_TAGDATATYPE_FLOAT,
    FMOD_TAGDATATYPE_STRING,
    FMOD_TAGDATATYPE_STRING_UTF16,
    FMOD_TAGDATATYPE_STRING_UTF16BE,
    FMOD_TAGDATATYPE_STRING_UTF8,
    FMOD_TAGDATATYPE_CDTOC,

    FMOD_TAGDATATYPE_MAX,               
    FMOD_TAGDATATYPE_FORCEINT = 65536   
} FMOD_TAGDATATYPE;

typedef enum
{
    FMOD_DELAYTYPE_END_MS,              
    FMOD_DELAYTYPE_DSPCLOCK_START,      
    FMOD_DELAYTYPE_DSPCLOCK_END,        
    FMOD_DELAYTYPE_DSPCLOCK_PAUSE,      

    FMOD_DELAYTYPE_MAX,                 
    FMOD_DELAYTYPE_FORCEINT = 65536     
} FMOD_DELAYTYPE;

#define FMOD_64BIT_ADD(_hi1, _lo1, _hi2, _lo2) _hi1 += ((_hi2) + ((((_lo1) + (_lo2)) < (_lo1)) ? 1 : 0)); (_lo1) += (_lo2);
#define FMOD_64BIT_SUB(_hi1, _lo1, _hi2, _lo2) _hi1 -= ((_hi2) + ((((_lo1) - (_lo2)) > (_lo1)) ? 1 : 0)); (_lo1) -= (_lo2);

typedef struct FMOD_TAG
{
    FMOD_TAGTYPE      type;         
    FMOD_TAGDATATYPE  datatype;     
    char             *name;         
    void             *data;         
    unsigned int      datalen;      
    FMOD_BOOL         updated;      
} FMOD_TAG;

typedef struct FMOD_CDTOC
{
    int numtracks;                  
    int min[100];                   
    int sec[100];                   
    int frame[100];                 
} FMOD_CDTOC;

#define FMOD_TIMEUNIT_MS                0x00000001  
#define FMOD_TIMEUNIT_PCM               0x00000002  
#define FMOD_TIMEUNIT_PCMBYTES          0x00000004  
#define FMOD_TIMEUNIT_RAWBYTES          0x00000008  
#define FMOD_TIMEUNIT_PCMFRACTION       0x00000010  
#define FMOD_TIMEUNIT_MODORDER          0x00000100  
#define FMOD_TIMEUNIT_MODROW            0x00000200  
#define FMOD_TIMEUNIT_MODPATTERN        0x00000400  
#define FMOD_TIMEUNIT_SENTENCE_MS       0x00010000  
#define FMOD_TIMEUNIT_SENTENCE_PCM      0x00020000  
#define FMOD_TIMEUNIT_SENTENCE_PCMBYTES 0x00040000  
#define FMOD_TIMEUNIT_SENTENCE          0x00080000  
#define FMOD_TIMEUNIT_SENTENCE_SUBSOUND 0x00100000  
#define FMOD_TIMEUNIT_BUFFERED          0x10000000  

typedef enum
{
    FMOD_SPEAKERMAPTYPE_DEFAULT,     
    FMOD_SPEAKERMAPTYPE_ALLMONO,     
    FMOD_SPEAKERMAPTYPE_ALLSTEREO,   
    FMOD_SPEAKERMAPTYPE_51_PROTOOLS  
} FMOD_SPEAKERMAPTYPE;

typedef struct FMOD_CREATESOUNDEXINFO
{
    int                            cbsize;             
    unsigned int                   length;             
    unsigned int                   fileoffset;         
    int                            numchannels;        
    int                            defaultfrequency;   
    FMOD_SOUND_FORMAT              format;             
    unsigned int                   decodebuffersize;   
    int                            initialsubsound;    
    int                            numsubsounds;       
    int                           *inclusionlist;      
    int                            inclusionlistnum;   
    FMOD_SOUND_PCMREADCALLBACK     pcmreadcallback;    
    FMOD_SOUND_PCMSETPOSCALLBACK   pcmsetposcallback;  
    FMOD_SOUND_NONBLOCKCALLBACK    nonblockcallback;   
    const char                    *dlsname;            
    const char                    *encryptionkey;      
    int                            maxpolyphony;       
    void                          *userdata;           
    FMOD_SOUND_TYPE                suggestedsoundtype; 
    FMOD_FILE_OPENCALLBACK         useropen;           
    FMOD_FILE_CLOSECALLBACK        userclose;          
    FMOD_FILE_READCALLBACK         userread;           
    FMOD_FILE_SEEKCALLBACK         userseek;           
    FMOD_FILE_ASYNCREADCALLBACK    userasyncread;      
    FMOD_FILE_ASYNCCANCELCALLBACK  userasynccancel;    
    FMOD_SPEAKERMAPTYPE            speakermap;         
    FMOD_SOUNDGROUP               *initialsoundgroup;  
    unsigned int                   initialseekposition;
    FMOD_TIMEUNIT                  initialseekpostype; 
    int                            ignoresetfilesystem;
    int                            cddaforceaspi;      
    unsigned int                   audioqueuepolicy;    
    unsigned int                   minmidigranularity; 
    int                            nonblockthreadid;   
} FMOD_CREATESOUNDEXINFO;

typedef struct FMOD_REVERB_PROPERTIES
{                                   
    int          Instance;          
    int          Environment;       
    float        EnvDiffusion;      
    int          Room;              
    int          RoomHF;            
    int          RoomLF;            
    float        DecayTime;         
    float        DecayHFRatio;      
    float        DecayLFRatio;      
    int          Reflections;       
    float        ReflectionsDelay;  
    int          Reverb;            
    float        ReverbDelay;       
    float        ModulationTime;    
    float        ModulationDepth;   
    float        HFReference;       
    float        LFReference;       
    float        Diffusion;         
    float        Density;           
    unsigned int Flags;             
} FMOD_REVERB_PROPERTIES;

#define FMOD_REVERB_FLAGS_HIGHQUALITYREVERB     0x00000400 
#define FMOD_REVERB_FLAGS_HIGHQUALITYDPL2REVERB 0x00000800 
#define FMOD_REVERB_FLAGS_HARDWAREONLY          0x00001000 
#define FMOD_REVERB_FLAGS_DEFAULT               0x00000000

#define FMOD_PRESET_OFF              {  0, -1,  1.00f, -10000, -10000, 0,   1.00f,  1.00f, 1.0f,  -2602, 0.007f,   200, 0.011f, 0.25f, 0.000f, 5000.0f, 250.0f,   0.0f,   0.0f, 0x33f }
#define FMOD_PRESET_GENERIC          {  0,  0,  1.00f, -1000,  -100,   0,   1.49f,  0.83f, 1.0f,  -2602, 0.007f,   200, 0.011f, 0.25f, 0.000f, 5000.0f, 250.0f, 100.0f, 100.0f, 0x3f }
#define FMOD_PRESET_PADDEDCELL       {  0,  1,  1.00f, -1000,  -6000,  0,   0.17f,  0.10f, 1.0f,  -1204, 0.001f,   207, 0.002f, 0.25f, 0.000f, 5000.0f, 250.0f, 100.0f, 100.0f, 0x3f }
#define FMOD_PRESET_ROOM             {  0,  2,  1.00f, -1000,  -454,   0,   0.40f,  0.83f, 1.0f,  -1646, 0.002f,    53, 0.003f, 0.25f, 0.000f, 5000.0f, 250.0f, 100.0f, 100.0f, 0x3f }
#define FMOD_PRESET_BATHROOM         {  0,  3,  1.00f, -1000,  -1200,  0,   1.49f,  0.54f, 1.0f,   -370, 0.007f,  1030, 0.011f, 0.25f, 0.000f, 5000.0f, 250.0f, 100.0f,  60.0f, 0x3f }
#define FMOD_PRESET_LIVINGROOM       {  0,  4,  1.00f, -1000,  -6000,  0,   0.50f,  0.10f, 1.0f,  -1376, 0.003f, -1104, 0.004f, 0.25f, 0.000f, 5000.0f, 250.0f, 100.0f, 100.0f, 0x3f }
#define FMOD_PRESET_STONEROOM        {  0,  5,  1.00f, -1000,  -300,   0,   2.31f,  0.64f, 1.0f,   -711, 0.012f,    83, 0.017f, 0.25f, 0.000f, 5000.0f, 250.0f, 100.0f, 100.0f, 0x3f }
#define FMOD_PRESET_AUDITORIUM       {  0,  6,  1.00f, -1000,  -476,   0,   4.32f,  0.59f, 1.0f,   -789, 0.020f,  -289, 0.030f, 0.25f, 0.000f, 5000.0f, 250.0f, 100.0f, 100.0f, 0x3f }
#define FMOD_PRESET_CONCERTHALL      {  0,  7,  1.00f, -1000,  -500,   0,   3.92f,  0.70f, 1.0f,  -1230, 0.020f,    -2, 0.029f, 0.25f, 0.000f, 5000.0f, 250.0f, 100.0f, 100.0f, 0x3f }
#define FMOD_PRESET_CAVE             {  0,  8,  1.00f, -1000,  0,      0,   2.91f,  1.30f, 1.0f,   -602, 0.015f,  -302, 0.022f, 0.25f, 0.000f, 5000.0f, 250.0f, 100.0f, 100.0f, 0x1f }
#define FMOD_PRESET_ARENA            {  0,  9,  1.00f, -1000,  -698,   0,   7.24f,  0.33f, 1.0f,  -1166, 0.020f,    16, 0.030f, 0.25f, 0.000f, 5000.0f, 250.0f, 100.0f, 100.0f, 0x3f }
#define FMOD_PRESET_HANGAR           {  0,  10, 1.00f, -1000,  -1000,  0,   10.05f, 0.23f, 1.0f,   -602, 0.020f,   198, 0.030f, 0.25f, 0.000f, 5000.0f, 250.0f, 100.0f, 100.0f, 0x3f }
#define FMOD_PRESET_CARPETTEDHALLWAY {  0,  11, 1.00f, -1000,  -4000,  0,   0.30f,  0.10f, 1.0f,  -1831, 0.002f, -1630, 0.030f, 0.25f, 0.000f, 5000.0f, 250.0f, 100.0f, 100.0f, 0x3f }
#define FMOD_PRESET_HALLWAY          {  0,  12, 1.00f, -1000,  -300,   0,   1.49f,  0.59f, 1.0f,  -1219, 0.007f,   441, 0.011f, 0.25f, 0.000f, 5000.0f, 250.0f, 100.0f, 100.0f, 0x3f }
#define FMOD_PRESET_STONECORRIDOR    {  0,  13, 1.00f, -1000,  -237,   0,   2.70f,  0.79f, 1.0f,  -1214, 0.013f,   395, 0.020f, 0.25f, 0.000f, 5000.0f, 250.0f, 100.0f, 100.0f, 0x3f }
#define FMOD_PRESET_ALLEY            {  0,  14, 0.30f, -1000,  -270,   0,   1.49f,  0.86f, 1.0f,  -1204, 0.007f,    -4, 0.011f, 0.25f, 0.000f, 5000.0f, 250.0f, 100.0f, 100.0f, 0x3f }
#define FMOD_PRESET_FOREST           {  0,  15, 0.30f, -1000,  -3300,  0,   1.49f,  0.54f, 1.0f,  -2560, 0.162f,  -229, 0.088f, 0.25f, 0.000f, 5000.0f, 250.0f,  79.0f, 100.0f, 0x3f }
#define FMOD_PRESET_CITY             {  0,  16, 0.50f, -1000,  -800,   0,   1.49f,  0.67f, 1.0f,  -2273, 0.007f, -1691, 0.011f, 0.25f, 0.000f, 5000.0f, 250.0f,  50.0f, 100.0f, 0x3f }
#define FMOD_PRESET_MOUNTAINS        {  0,  17, 0.27f, -1000,  -2500,  0,   1.49f,  0.21f, 1.0f,  -2780, 0.300f, -1434, 0.100f, 0.25f, 0.000f, 5000.0f, 250.0f,  27.0f, 100.0f, 0x1f }
#define FMOD_PRESET_QUARRY           {  0,  18, 1.00f, -1000,  -1000,  0,   1.49f,  0.83f, 1.0f, -10000, 0.061f,   500, 0.025f, 0.25f, 0.000f, 5000.0f, 250.0f, 100.0f, 100.0f, 0x3f }
#define FMOD_PRESET_PLAIN            {  0,  19, 0.21f, -1000,  -2000,  0,   1.49f,  0.50f, 1.0f,  -2466, 0.179f, -1926, 0.100f, 0.25f, 0.000f, 5000.0f, 250.0f,  21.0f, 100.0f, 0x3f }
#define FMOD_PRESET_PARKINGLOT       {  0,  20, 1.00f, -1000,  0,      0,   1.65f,  1.50f, 1.0f,  -1363, 0.008f, -1153, 0.012f, 0.25f, 0.000f, 5000.0f, 250.0f, 100.0f, 100.0f, 0x1f }
#define FMOD_PRESET_SEWERPIPE        {  0,  21, 0.80f, -1000,  -1000,  0,   2.81f,  0.14f, 1.0f,    429, 0.014f,  1023, 0.021f, 0.25f, 0.000f, 5000.0f, 250.0f,  80.0f,  60.0f, 0x3f }
#define FMOD_PRESET_UNDERWATER       {  0,  22, 1.00f, -1000,  -4000,  0,   1.49f,  0.10f, 1.0f,   -449, 0.007f,  1700, 0.011f, 1.18f, 0.348f, 5000.0f, 250.0f, 100.0f, 100.0f, 0x3f }


#define FMOD_PRESET_PSP_ROOM         {  0,  1,  0,     0,      0,      0,   0.0f,   0.0f,  0.0f,     0,  0.000f,     0, 0.000f, 0.00f, 0.000f, 0000.0f,   0.0f,  0.0f,    0.0f, 0x31f }
#define FMOD_PRESET_PSP_STUDIO_A     {  0,  2,  0,     0,      0,      0,   0.0f,   0.0f,  0.0f,     0,  0.000f,     0, 0.000f, 0.00f, 0.000f, 0000.0f,   0.0f,  0.0f,    0.0f, 0x31f }
#define FMOD_PRESET_PSP_STUDIO_B     {  0,  3,  0,     0,      0,      0,   0.0f,   0.0f,  0.0f,     0,  0.000f,     0, 0.000f, 0.00f, 0.000f, 0000.0f,   0.0f,  0.0f,    0.0f, 0x31f }
#define FMOD_PRESET_PSP_STUDIO_C     {  0,  4,  0,     0,      0,      0,   0.0f,   0.0f,  0.0f,     0,  0.000f,     0, 0.000f, 0.00f, 0.000f, 0000.0f,   0.0f,  0.0f,    0.0f, 0x31f }
#define FMOD_PRESET_PSP_HALL         {  0,  5,  0,     0,      0,      0,   0.0f,   0.0f,  0.0f,     0,  0.000f,     0, 0.000f, 0.00f, 0.000f, 0000.0f,   0.0f,  0.0f,    0.0f, 0x31f }
#define FMOD_PRESET_PSP_SPACE        {  0,  6,  0,     0,      0,      0,   0.0f,   0.0f,  0.0f,     0,  0.000f,     0, 0.000f, 0.00f, 0.000f, 0000.0f,   0.0f,  0.0f,    0.0f, 0x31f }
#define FMOD_PRESET_PSP_ECHO         {  0,  7,  0,     0,      0,      0,   0.0f,   0.0f,  0.0f,     0,  0.000f,     0, 0.000f, 0.00f, 0.000f, 0000.0f,   0.0f,  0.0f,    0.0f, 0x31f }
#define FMOD_PRESET_PSP_DELAY        {  0,  8,  0,     0,      0,      0,   0.0f,   0.0f,  0.0f,     0,  0.000f,     0, 0.000f, 0.00f, 0.000f, 0000.0f,   0.0f,  0.0f,    0.0f, 0x31f }
#define FMOD_PRESET_PSP_PIPE         {  0,  9,  0,     0,      0,      0,   0.0f,   0.0f,  0.0f,     0,  0.000f,     0, 0.000f, 0.00f, 0.000f, 0000.0f,   0.0f,  0.0f,    0.0f, 0x31f }

typedef struct FMOD_REVERB_CHANNELPROPERTIES
{                                      
    int          Direct;               
    int          Room;                 
    unsigned int Flags;                
    FMOD_DSP    *ConnectionPoint;      
} FMOD_REVERB_CHANNELPROPERTIES;

#define FMOD_REVERB_CHANNELFLAGS_INSTANCE0     0x00000010 
#define FMOD_REVERB_CHANNELFLAGS_INSTANCE1     0x00000020 
#define FMOD_REVERB_CHANNELFLAGS_INSTANCE2     0x00000040 
#define FMOD_REVERB_CHANNELFLAGS_INSTANCE3     0x00000080 

#define FMOD_REVERB_CHANNELFLAGS_DEFAULT       FMOD_REVERB_CHANNELFLAGS_INSTANCE0

typedef struct FMOD_ADVANCEDSETTINGS
{                       
    int             cbsize;                     
    int             maxMPEGcodecs;              
    int             maxADPCMcodecs;             
    int             maxXMAcodecs;               
    int             maxCELTcodecs;                  
    int             maxVORBIScodecs;                
    int             maxAT9Codecs;                   
    int             maxPCMcodecs;               
    int             ASIONumChannels;            
    char          **ASIOChannelList;            
    FMOD_SPEAKER   *ASIOSpeakerList;            
    int             max3DReverbDSPs;            
    float           HRTFMinAngle;               
    float           HRTFMaxAngle;           
    float           HRTFFreq;               
    float           vol0virtualvol;         
    int             eventqueuesize;         
    unsigned int    defaultDecodeBufferSize;
    char           *debugLogFilename; 
    unsigned short  profileport;      
    unsigned int    geometryMaxFadeTime; 
    unsigned int    maxSpectrumWaveDataBuffers;
    unsigned int    musicSystemCacheDelay;
    float           distanceFilterCenterFreq;
    unsigned int    stackSizeStream; 
    unsigned int    stackSizeNonBlocking;
    unsigned int    stackSizeMixer; 
} FMOD_ADVANCEDSETTINGS;

typedef enum
{
    FMOD_CHANNEL_FREE  = -1,
    FMOD_CHANNEL_REUSE = -2 
} FMOD_CHANNELINDEX;

typedef struct FMOD_CODEC_STATE FMOD_CODEC_STATE;
typedef struct FMOD_CODEC_WAVEFORMAT FMOD_CODEC_WAVEFORMAT;

typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_CODEC_OPENCALLBACK)        (FMOD_CODEC_STATE *codec_state, FMOD_MODE usermode, FMOD_CREATESOUNDEXINFO *userexinfo);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_CODEC_CLOSECALLBACK)       (FMOD_CODEC_STATE *codec_state);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_CODEC_READCALLBACK)        (FMOD_CODEC_STATE *codec_state, void *buffer, unsigned int sizebytes, unsigned int *bytesread);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_CODEC_GETLENGTHCALLBACK)   (FMOD_CODEC_STATE *codec_state, unsigned int *length, FMOD_TIMEUNIT lengthtype);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_CODEC_SETPOSITIONCALLBACK) (FMOD_CODEC_STATE *codec_state, int subsound, unsigned int position, FMOD_TIMEUNIT postype);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_CODEC_GETPOSITIONCALLBACK) (FMOD_CODEC_STATE *codec_state, unsigned int *position, FMOD_TIMEUNIT postype);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_CODEC_SOUNDCREATECALLBACK) (FMOD_CODEC_STATE *codec_state, int subsound, FMOD_SOUND *sound);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_CODEC_METADATACALLBACK)    (FMOD_CODEC_STATE *codec_state, FMOD_TAGTYPE tagtype, char *name, void *data, unsigned int datalen, FMOD_TAGDATATYPE datatype, int unique);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_CODEC_GETWAVEFORMAT)       (FMOD_CODEC_STATE *codec_state, int index, FMOD_CODEC_WAVEFORMAT *waveformat);

typedef struct FMOD_CODEC_DESCRIPTION
{
    const char                     *name;            
    unsigned int                    version;         
    int                             defaultasstream; 
    FMOD_TIMEUNIT                   timeunits;       
    FMOD_CODEC_OPENCALLBACK         open;            
    FMOD_CODEC_CLOSECALLBACK        close;           
    FMOD_CODEC_READCALLBACK         read;            
    FMOD_CODEC_GETLENGTHCALLBACK    getlength;       
    FMOD_CODEC_SETPOSITIONCALLBACK  setposition;     
    FMOD_CODEC_GETPOSITIONCALLBACK  getposition;     
    FMOD_CODEC_SOUNDCREATECALLBACK  soundcreate;     
    FMOD_CODEC_GETWAVEFORMAT        getwaveformat;   
} FMOD_CODEC_DESCRIPTION;

struct FMOD_CODEC_WAVEFORMAT
{
    char               name[256];  
    FMOD_SOUND_FORMAT  format;     
    int                channels;   
    int                frequency;  
    unsigned int       lengthbytes;
    unsigned int       lengthpcm;  
    int                blockalign; 
    int                loopstart;  
    int                loopend;    
    FMOD_MODE          mode;       
    unsigned int       channelmask;
};

struct FMOD_CODEC_STATE
{
    int                         numsubsounds;
    FMOD_CODEC_WAVEFORMAT      *waveformat;
    void                       *plugindata;
                                               
    void                       *filehandle;
    unsigned int                filesize;
    FMOD_FILE_READCALLBACK      fileread;
    FMOD_FILE_SEEKCALLBACK      fileseek;
    FMOD_CODEC_METADATACALLBACK metadata;
};

typedef struct FMOD_DSP_STATE FMOD_DSP_STATE;

typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_DSP_CREATECALLBACK)     (FMOD_DSP_STATE *dsp_state);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_DSP_RELEASECALLBACK)    (FMOD_DSP_STATE *dsp_state);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_DSP_RESETCALLBACK)      (FMOD_DSP_STATE *dsp_state);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_DSP_READCALLBACK)       (FMOD_DSP_STATE *dsp_state, float *inbuffer, float *outbuffer, unsigned int length, int inchannels, int outchannels);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_DSP_SETPOSITIONCALLBACK)(FMOD_DSP_STATE *dsp_state, unsigned int pos);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_DSP_SETPARAMCALLBACK)   (FMOD_DSP_STATE *dsp_state, int index, float value);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_DSP_GETPARAMCALLBACK)   (FMOD_DSP_STATE *dsp_state, int index, float *value, char *valuestr);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_DSP_DIALOGCALLBACK)     (FMOD_DSP_STATE *dsp_state, void *hwnd, int show);

typedef enum
{
    FMOD_DSP_TYPE_UNKNOWN,
    FMOD_DSP_TYPE_MIXER,  
    FMOD_DSP_TYPE_OSCILLATOR,
    FMOD_DSP_TYPE_LOWPASS,   
    FMOD_DSP_TYPE_ITLOWPASS, 
    FMOD_DSP_TYPE_HIGHPASS,  
    FMOD_DSP_TYPE_ECHO,      
    FMOD_DSP_TYPE_FLANGE,    
    FMOD_DSP_TYPE_DISTORTION,
    FMOD_DSP_TYPE_NORMALIZE, 
    FMOD_DSP_TYPE_PARAMEQ,   
    FMOD_DSP_TYPE_PITCHSHIFT,
    FMOD_DSP_TYPE_CHORUS,    
    FMOD_DSP_TYPE_VSTPLUGIN, 
    FMOD_DSP_TYPE_WINAMPPLUGIN, 
    FMOD_DSP_TYPE_ITECHO,       
    FMOD_DSP_TYPE_COMPRESSOR,   
    FMOD_DSP_TYPE_SFXREVERB,    
    FMOD_DSP_TYPE_LOWPASS_SIMPLE, 
    FMOD_DSP_TYPE_DELAY,          
    FMOD_DSP_TYPE_TREMOLO,        
    FMOD_DSP_TYPE_LADSPAPLUGIN,   
    FMOD_DSP_TYPE_HIGHPASS_SIMPLE,
    FMOD_DSP_TYPE_HARDWARE = 1000,
    FMOD_DSP_TYPE_FORCEINT = 65536
} FMOD_DSP_TYPE;

typedef struct FMOD_DSP_PARAMETERDESC
{
    float       max;                                
    float       defaultval;                         
    char        name[16];                           
    char        label[16];                          
    const char *description;                        
} FMOD_DSP_PARAMETERDESC;

typedef struct FMOD_DSP_DESCRIPTION
{
    char                         name[32];           
    unsigned int                 version;            
    int                          channels;           
    FMOD_DSP_CREATECALLBACK      create;             
    FMOD_DSP_RELEASECALLBACK     release;            
    FMOD_DSP_RESETCALLBACK       reset;              
    FMOD_DSP_READCALLBACK        read;               
    FMOD_DSP_SETPOSITIONCALLBACK setposition;        

    int                          numparameters;      
    FMOD_DSP_PARAMETERDESC      *paramdesc;          
    FMOD_DSP_SETPARAMCALLBACK    setparameter;       
    FMOD_DSP_GETPARAMCALLBACK    getparameter;       
    FMOD_DSP_DIALOGCALLBACK      config;             
    int                          configwidth;        
    int                          configheight;       
    void                        *userdata;           
} FMOD_DSP_DESCRIPTION;

struct FMOD_DSP_STATE
{
    FMOD_DSP      *instance;      
    void          *plugindata;    
	unsigned short speakermask;	  
};

typedef enum
{
    FMOD_DSP_OSCILLATOR_TYPE,   
    FMOD_DSP_OSCILLATOR_RATE    
} FMOD_DSP_OSCILLATOR;

typedef enum
{
    FMOD_DSP_LOWPASS_CUTOFF,    
    FMOD_DSP_LOWPASS_RESONANCE  
} FMOD_DSP_LOWPASS;

typedef enum
{
    FMOD_DSP_ITLOWPASS_CUTOFF,    
    FMOD_DSP_ITLOWPASS_RESONANCE  
} FMOD_DSP_ITLOWPASS;

typedef enum
{
    FMOD_DSP_HIGHPASS_CUTOFF,    
    FMOD_DSP_HIGHPASS_RESONANCE  
} FMOD_DSP_HIGHPASS;

typedef enum
{
    FMOD_DSP_ECHO_DELAY,       
    FMOD_DSP_ECHO_DECAYRATIO,  
    FMOD_DSP_ECHO_MAXCHANNELS, 
    FMOD_DSP_ECHO_DRYMIX,      
    FMOD_DSP_ECHO_WETMIX       
} FMOD_DSP_ECHO;

typedef enum
{
    FMOD_DSP_DELAY_CH0,      
    FMOD_DSP_DELAY_CH1,      
    FMOD_DSP_DELAY_CH2,      
    FMOD_DSP_DELAY_CH3,      
    FMOD_DSP_DELAY_CH4,      
    FMOD_DSP_DELAY_CH5,      
    FMOD_DSP_DELAY_CH6,      
    FMOD_DSP_DELAY_CH7,      
    FMOD_DSP_DELAY_CH8,      
    FMOD_DSP_DELAY_CH9,      
    FMOD_DSP_DELAY_CH10,     
    FMOD_DSP_DELAY_CH11,     
    FMOD_DSP_DELAY_CH12,     
    FMOD_DSP_DELAY_CH13,     
    FMOD_DSP_DELAY_CH14,     
    FMOD_DSP_DELAY_CH15,     
    FMOD_DSP_DELAY_MAXDELAY  
} FMOD_DSP_DELAY;

typedef enum
{
    FMOD_DSP_FLANGE_DRYMIX,      
    FMOD_DSP_FLANGE_WETMIX,      
    FMOD_DSP_FLANGE_DEPTH,       
    FMOD_DSP_FLANGE_RATE         
} FMOD_DSP_FLANGE;

typedef enum
{
    FMOD_DSP_TREMOLO_FREQUENCY,     
    FMOD_DSP_TREMOLO_DEPTH,         
    FMOD_DSP_TREMOLO_SHAPE,         
    FMOD_DSP_TREMOLO_SKEW,          
    FMOD_DSP_TREMOLO_DUTY,          
    FMOD_DSP_TREMOLO_SQUARE,        
    FMOD_DSP_TREMOLO_PHASE,         
    FMOD_DSP_TREMOLO_SPREAD         
} FMOD_DSP_TREMOLO;

typedef enum
{
    FMOD_DSP_DISTORTION_LEVEL    
} FMOD_DSP_DISTORTION;

typedef enum
{
    FMOD_DSP_NORMALIZE_FADETIME,    
    FMOD_DSP_NORMALIZE_THRESHHOLD,  
    FMOD_DSP_NORMALIZE_MAXAMP       
} FMOD_DSP_NORMALIZE;

typedef enum
{
    FMOD_DSP_PARAMEQ_CENTER,     
    FMOD_DSP_PARAMEQ_BANDWIDTH,  
    FMOD_DSP_PARAMEQ_GAIN        
} FMOD_DSP_PARAMEQ;

typedef enum
{
    FMOD_DSP_PITCHSHIFT_PITCH,       
    FMOD_DSP_PITCHSHIFT_FFTSIZE,     
    FMOD_DSP_PITCHSHIFT_OVERLAP,     
    FMOD_DSP_PITCHSHIFT_MAXCHANNELS  
} FMOD_DSP_PITCHSHIFT;

typedef enum
{
    FMOD_DSP_CHORUS_DRYMIX,   
    FMOD_DSP_CHORUS_WETMIX1,  
    FMOD_DSP_CHORUS_WETMIX2,  
    FMOD_DSP_CHORUS_WETMIX3,  
    FMOD_DSP_CHORUS_DELAY,    
    FMOD_DSP_CHORUS_RATE,     
    FMOD_DSP_CHORUS_DEPTH     
} FMOD_DSP_CHORUS;

typedef enum
{
    FMOD_DSP_ITECHO_WETDRYMIX,      
    FMOD_DSP_ITECHO_FEEDBACK,       
    FMOD_DSP_ITECHO_LEFTDELAY,      
    FMOD_DSP_ITECHO_RIGHTDELAY,     
    FMOD_DSP_ITECHO_PANDELAY        
} FMOD_DSP_ITECHO;

typedef enum
{
    FMOD_DSP_COMPRESSOR_THRESHOLD,  
    FMOD_DSP_COMPRESSOR_ATTACK,     
    FMOD_DSP_COMPRESSOR_RELEASE,    
    FMOD_DSP_COMPRESSOR_GAINMAKEUP  
} FMOD_DSP_COMPRESSOR;

typedef enum
{
    FMOD_DSP_SFXREVERB_DRYLEVEL,            
    FMOD_DSP_SFXREVERB_ROOM,                
    FMOD_DSP_SFXREVERB_ROOMHF,              
    FMOD_DSP_SFXREVERB_DECAYTIME,           
    FMOD_DSP_SFXREVERB_DECAYHFRATIO,        
    FMOD_DSP_SFXREVERB_REFLECTIONSLEVEL,    
    FMOD_DSP_SFXREVERB_REFLECTIONSDELAY,    
    FMOD_DSP_SFXREVERB_REVERBLEVEL,         
    FMOD_DSP_SFXREVERB_REVERBDELAY,         
    FMOD_DSP_SFXREVERB_DIFFUSION,           
    FMOD_DSP_SFXREVERB_DENSITY,             
    FMOD_DSP_SFXREVERB_HFREFERENCE,         
    FMOD_DSP_SFXREVERB_ROOMLF,              
    FMOD_DSP_SFXREVERB_LFREFERENCE          
} FMOD_DSP_SFXREVERB;

typedef enum
{
    FMOD_DSP_LOWPASS_SIMPLE_CUTOFF     
} FMOD_DSP_LOWPASS_SIMPLE;

typedef enum
{
    FMOD_DSP_HIGHPASS_SIMPLE_CUTOFF     
} FMOD_DSP_HIGHPASS_SIMPLE;

typedef struct FMOD_MEMORY_USAGE_DETAILS
{
    unsigned int other;                          
    unsigned int string;                         
    unsigned int system;                         
    unsigned int plugins;                        
    unsigned int output;                         
    unsigned int channel;                        
    unsigned int channelgroup;                   
    unsigned int codec;                          
    unsigned int file;                           
    unsigned int sound;                          
    unsigned int secondaryram;                   
    unsigned int soundgroup;                     
    unsigned int streambuffer;                   
    unsigned int dspconnection;                  
    unsigned int dsp;                            
    unsigned int dspcodec;                       
    unsigned int profile;                        
    unsigned int recordbuffer;                   
    unsigned int reverb;                         
    unsigned int reverbchannelprops;             
    unsigned int geometry;                       
    unsigned int syncpoint;                      
    unsigned int eventsystem;                    
    unsigned int musicsystem;                    
    unsigned int fev;                            
    unsigned int memoryfsb;                      
    unsigned int eventproject;                   
    unsigned int eventgroupi;                    
    unsigned int soundbankclass;                 
    unsigned int soundbanklist;                  
    unsigned int streaminstance;                 
    unsigned int sounddefclass;                  
    unsigned int sounddefdefclass;               
    unsigned int sounddefpool;                   
    unsigned int reverbdef;                      
    unsigned int eventreverb;                    
    unsigned int userproperty;                   
    unsigned int eventinstance;                  
    unsigned int eventinstance_complex;          
    unsigned int eventinstance_simple;           
    unsigned int eventinstance_layer;            
    unsigned int eventinstance_sound;            
    unsigned int eventenvelope;                  
    unsigned int eventenvelopedef;               
    unsigned int eventparameter;                 
    unsigned int eventcategory;                  
    unsigned int eventenvelopepoint;             
    unsigned int eventinstancepool;              
} FMOD_MEMORY_USAGE_DETAILS;

#define FMOD_MEMBITS_OTHER                       0x00000001  
#define FMOD_MEMBITS_STRING                      0x00000002  

#define FMOD_MEMBITS_SYSTEM                      0x00000004  
#define FMOD_MEMBITS_PLUGINS                     0x00000008  
#define FMOD_MEMBITS_OUTPUT                      0x00000010  
#define FMOD_MEMBITS_CHANNEL                     0x00000020  
#define FMOD_MEMBITS_CHANNELGROUP                0x00000040  
#define FMOD_MEMBITS_CODEC                       0x00000080  
#define FMOD_MEMBITS_FILE                        0x00000100  
#define FMOD_MEMBITS_SOUND                       0x00000200  
#define FMOD_MEMBITS_SOUND_SECONDARYRAM          0x00000400  
#define FMOD_MEMBITS_SOUNDGROUP                  0x00000800  
#define FMOD_MEMBITS_STREAMBUFFER                0x00001000  
#define FMOD_MEMBITS_DSPCONNECTION               0x00002000  
#define FMOD_MEMBITS_DSP                         0x00004000  
#define FMOD_MEMBITS_DSPCODEC                    0x00008000  
#define FMOD_MEMBITS_PROFILE                     0x00010000  
#define FMOD_MEMBITS_RECORDBUFFER                0x00020000  
#define FMOD_MEMBITS_REVERB                      0x00040000  
#define FMOD_MEMBITS_REVERBCHANNELPROPS          0x00080000  
#define FMOD_MEMBITS_GEOMETRY                    0x00100000  
#define FMOD_MEMBITS_SYNCPOINT                   0x00200000  
#define FMOD_MEMBITS_ALL                         0xffffffff  

#define FMOD_EVENT_MEMBITS_EVENTSYSTEM           0x00000001  
#define FMOD_EVENT_MEMBITS_MUSICSYSTEM           0x00000002  
#define FMOD_EVENT_MEMBITS_FEV                   0x00000004  
#define FMOD_EVENT_MEMBITS_MEMORYFSB             0x00000008  
#define FMOD_EVENT_MEMBITS_EVENTPROJECT          0x00000010  
#define FMOD_EVENT_MEMBITS_EVENTGROUPI           0x00000020  
#define FMOD_EVENT_MEMBITS_SOUNDBANKCLASS        0x00000040  
#define FMOD_EVENT_MEMBITS_SOUNDBANKLIST         0x00000080  
#define FMOD_EVENT_MEMBITS_STREAMINSTANCE        0x00000100  
#define FMOD_EVENT_MEMBITS_SOUNDDEFCLASS         0x00000200  
#define FMOD_EVENT_MEMBITS_SOUNDDEFDEFCLASS      0x00000400  
#define FMOD_EVENT_MEMBITS_SOUNDDEFPOOL          0x00000800  
#define FMOD_EVENT_MEMBITS_REVERBDEF             0x00001000  
#define FMOD_EVENT_MEMBITS_EVENTREVERB           0x00002000  
#define FMOD_EVENT_MEMBITS_USERPROPERTY          0x00004000  
#define FMOD_EVENT_MEMBITS_EVENTINSTANCE         0x00008000  
#define FMOD_EVENT_MEMBITS_EVENTINSTANCE_COMPLEX 0x00010000  
#define FMOD_EVENT_MEMBITS_EVENTINSTANCE_SIMPLE  0x00020000  
#define FMOD_EVENT_MEMBITS_EVENTINSTANCE_LAYER   0x00040000  
#define FMOD_EVENT_MEMBITS_EVENTINSTANCE_SOUND   0x00080000  
#define FMOD_EVENT_MEMBITS_EVENTENVELOPE         0x00100000  
#define FMOD_EVENT_MEMBITS_EVENTENVELOPEDEF      0x00200000  
#define FMOD_EVENT_MEMBITS_EVENTPARAMETER        0x00400000  
#define FMOD_EVENT_MEMBITS_EVENTCATEGORY         0x00800000  
#define FMOD_EVENT_MEMBITS_EVENTENVELOPEPOINT    0x01000000  
#define FMOD_EVENT_MEMBITS_EVENTINSTANCEPOOL     0x02000000  
#define FMOD_EVENT_MEMBITS_ALL                   0xffffffff  


#define FMOD_EVENT_MEMBITS_EVENTINSTANCE_GROUP   (FMOD_EVENT_MEMBITS_EVENTINSTANCE            | \
                                                     FMOD_EVENT_MEMBITS_EVENTINSTANCE_COMPLEX | \
                                                     FMOD_EVENT_MEMBITS_EVENTINSTANCE_SIMPLE  | \
                                                     FMOD_EVENT_MEMBITS_EVENTINSTANCE_LAYER   | \
                                                     FMOD_EVENT_MEMBITS_EVENTINSTANCE_SOUND)


#define FMOD_EVENT_MEMBITS_SOUNDDEF_GROUP        (FMOD_EVENT_MEMBITS_SOUNDDEFCLASS            | \
                                                     FMOD_EVENT_MEMBITS_SOUNDDEFDEFCLASS      | \
                                                     FMOD_EVENT_MEMBITS_SOUNDDEFPOOL)

													 typedef struct FMOD_OUTPUT_STATE FMOD_OUTPUT_STATE;

typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_OUTPUT_GETNUMDRIVERSCALLBACK)(FMOD_OUTPUT_STATE *output_state, int *numdrivers);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_OUTPUT_GETDRIVERNAMECALLBACK)(FMOD_OUTPUT_STATE *output_state, int id, char *name, int namelen);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_OUTPUT_GETDRIVERCAPSCALLBACK)(FMOD_OUTPUT_STATE *output_state, int id, FMOD_CAPS *caps);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_OUTPUT_INITCALLBACK)         (FMOD_OUTPUT_STATE *output_state, int selecteddriver, FMOD_INITFLAGS flags, int *outputrate, int outputchannels, FMOD_SOUND_FORMAT *outputformat, int dspbufferlength, int dspnumbuffers, void *extradriverdata);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_OUTPUT_CLOSECALLBACK)        (FMOD_OUTPUT_STATE *output_state);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_OUTPUT_UPDATECALLBACK)       (FMOD_OUTPUT_STATE *output_state);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_OUTPUT_GETHANDLECALLBACK)    (FMOD_OUTPUT_STATE *output_state, void **handle);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_OUTPUT_GETPOSITIONCALLBACK)  (FMOD_OUTPUT_STATE *output_state, unsigned int *pcm);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_OUTPUT_LOCKCALLBACK)         (FMOD_OUTPUT_STATE *output_state, unsigned int offset, unsigned int length, void **ptr1, void **ptr2, unsigned int *len1, unsigned int *len2);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_OUTPUT_UNLOCKCALLBACK)       (FMOD_OUTPUT_STATE *output_state, void *ptr1, void *ptr2, unsigned int len1, unsigned int len2);
typedef FMOD_RESULT (NV_FMOD_APIENTRY *FMOD_OUTPUT_READFROMMIXER)        (FMOD_OUTPUT_STATE *output_state, void *buffer, unsigned int length);

typedef struct FMOD_OUTPUT_DESCRIPTION
{
    const char                        *name;                  
    unsigned int                       version;               
    int                                polling;                
    FMOD_OUTPUT_GETNUMDRIVERSCALLBACK  getnumdrivers;         
    FMOD_OUTPUT_GETDRIVERNAMECALLBACK  getdrivername;         
    FMOD_OUTPUT_GETDRIVERCAPSCALLBACK  getdrivercaps;         
    FMOD_OUTPUT_INITCALLBACK           init;                  
    FMOD_OUTPUT_CLOSECALLBACK          close;                 
    FMOD_OUTPUT_UPDATECALLBACK         update;                
    FMOD_OUTPUT_GETHANDLECALLBACK      gethandle;             
    FMOD_OUTPUT_GETPOSITIONCALLBACK    getposition;           
    FMOD_OUTPUT_LOCKCALLBACK           lock;                  
    FMOD_OUTPUT_UNLOCKCALLBACK         unlock;                
} FMOD_OUTPUT_DESCRIPTION;

struct FMOD_OUTPUT_STATE
{
    void                      *plugindata;      
    FMOD_OUTPUT_READFROMMIXER  readfrommixer;   
};


