// Copyright (C) 2014-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file program_manager.hh
 * @author Kornel Kisielewicz
 * @brief program manager
 */

#ifndef NV_ENGINE_PROGRAM_MANAGER_HH
#define NV_ENGINE_PROGRAM_MANAGER_HH

#include <nv/common.hh>
#include <nv/engine/resource_system.hh>

namespace nv
{

	class program_manager : public resource_manager< program >
	{
	public:
		program_manager( context* a_context );
		virtual string_view get_storage_name() const { return "programs"; }
		virtual string_view get_resource_name() const { return "program"; }
	protected:
		virtual resource_id load_resource( lua::table_guard& table );
		string_buffer load_source( lua::table_guard& table, const string_view& append );
		virtual void release( program p );
	private:
		context* m_context;
		const_string m_shader_head;
	};

}

#endif // NV_ENGINE_PROGRAM_MANAGER_HH
