#include <nv/core/logger.hh>
#include <nv/core/handle.hh>
#include <nv/core/math.hh>
#include <nv/core/string.hh>
#include <nv/core/random.hh>

int main(int, char* [])
{
	nv::random& r = nv::random::get();
	r.randomize();

	nv::logger log(nv::LOG_TRACE);
	log.add_sink( new nv::log_file_sink("log.txt"), nv::LOG_TRACE );
	log.add_sink( new nv::log_console_sink(), nv::LOG_TRACE );
	
	NV_LOG( nv::LOG_NOTICE, "Logging started" );

	{
		nv::handle_manager< nv::handle<> > manager;
		std::vector< nv::handle<> > created;

		for ( int i = 0; i < 32000; ++i )
		{
			if ( created.size() > 0 && r.urange( 0, 2 ) == 2 )
			{
				nv::uint32 roll = r.urange( 0, created.size() - 1 );
				nv::handle<> h = created[roll];
				NV_ASSERT( manager.is_valid( h ), "handle not valid!" );
				created.erase( created.begin() + roll );
				manager.free_handle( h );
			}
			else
			{
				created.push_back( manager.create_handle() );
			}
		}

		for ( const nv::handle<>& h : created )
		{
			NV_ASSERT( manager.is_valid( h ), "handle not valid!" );
		}


		for ( int i = 0; i < 32000; ++i )
		{
			if ( created.size() > 0 && r.urange( 0, 1 ) == 1 )
			{
				nv::uint32 roll = r.urange( 0, created.size() - 1 );
				nv::handle<> h = created[roll];
				created.erase( created.begin() + roll );
				manager.free_handle( h );
			}
			else
			{
				created.push_back( manager.create_handle() );
			}
		}

		for ( const nv::handle<>& h : created )
		{
			NV_ASSERT( manager.is_valid( h ), "handle not valid!" );
		}

		while ( created.size() > 0 )
		{
			nv::uint32 roll = r.urange( 0, created.size() - 1 );
			nv::handle<> h = created[roll];
			created.erase( created.begin() + roll );
			manager.free_handle( h );
		}

		for ( const nv::handle<>& h : created )
		{
			NV_ASSERT( manager.is_valid( h ), "handle not valid!" );
		}

		for ( int i = 0; i < 32000; ++i )
		{
			if ( created.size() > 0 && r.urange( 0, 1 ) == 1 )
			{
				nv::uint32 roll = r.urange( 0, created.size() - 1 );
				nv::handle<> h = created[roll];
				created.erase( created.begin() + roll );
				manager.free_handle( h );
			}
			else
			{
				created.push_back( manager.create_handle() );
			}
		}

		for ( const nv::handle<>& h : created )
		{
			NV_ASSERT( manager.is_valid( h ), "handle not valid!" );
		}

		while ( created.size() > 0 )
		{
			nv::uint32 roll = r.urange( 0, created.size() - 1 );
			nv::handle<> h = created[roll];
			created.erase( created.begin() + roll );
			manager.free_handle( h );
		}

		NV_LOG( nv::LOG_NOTICE, "Done" );

	}
	
	NV_LOG( nv::LOG_NOTICE, "Logging stopped" );

	return 0;
}

