// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#include "nv/io/c_file_system.hh"
#include "nv/io/c_stream.hh"
#include <cstdio>

using namespace nv;


c_file_system::c_file_system()
{

}

c_file_system::~c_file_system()
{

}

bool c_file_system::exists( const string_view& fpath )
{
	FILE* file = ::fopen( fpath.data(), "rb" );
	if ( !file )
	{
		return false;
	}
	::fclose( file );
	return true;
}

stream* c_file_system::open( const string_view& fpath, const string_view& fmode /*= "rb" */ )
{
	NV_ASSERT( !fpath.empty() && !fmode.empty(), "Bad parameters passed to open" );
	FILE* file = ::fopen( fpath.data(), fmode.data() );
	if ( !file )
	{
		return nullptr;
	}
	return new c_stream( file, fpath.data() );
}

nv::const_string c_file_system::slurp( const string_view& path )
{
	stream* fstream = open( path, "rb" );
	if ( !fstream ) return const_string();
	uint32 size = fstream->size();
	const_string result( nullptr, size );
	fstream->read( const_cast<char*>( result.data() ), size, 1 );
	delete fstream;
	return result;
}
