// Copyright (C) 2012-2013 Kornel Kisielewicz
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/gl/gl_vertex_buffer.hh"

#include "nv/lib/gl.hh"
#include "nv/gl/gl_enum.hh"

using namespace nv;

gl_vertex_buffer::gl_vertex_buffer( buffer_hint hint, int size, void* data ) 
	: vertex_buffer( hint, size ), m_name()
{
	if (data)
	{
		assign( data );
	}
}

void gl_vertex_buffer::assign( void* data )
{
	glBindBuffer( GL_ARRAY_BUFFER, m_name.get_value() );
	glBufferData( GL_ARRAY_BUFFER, m_size, data, buffer_hint_to_enum( m_hint ) );
	glBindBuffer( GL_ARRAY_BUFFER, 0);
}

void gl_vertex_buffer::bind()
{
	glBindBuffer( GL_ARRAY_BUFFER, m_name.get_value() );
}

void gl_vertex_buffer::unbind()
{
	glBindBuffer( GL_ARRAY_BUFFER, 0 );
}

bool gl_vertex_buffer::is_valid() const
{
	return m_name.is_valid();
}
