// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file vertex_buffer.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief Vertex buffer class
 */

#ifndef NV_VERTEX_BUFFER_HH
#define NV_VERTEX_BUFFER_HH

#include <nv/common.hh>

namespace nv
{

	enum buffer_hint
	{
		STATIC_DRAW,
		STREAM_DRAW,
		DYNAMIC_DRAW
	};

	class vertex_buffer
	{
	public:
		vertex_buffer( buffer_hint hint, int size ) { m_size = size; m_hint = hint; }
		virtual void assign( void* data ) = 0;
		virtual void bind() = 0;
		virtual void unbind() = 0;
		virtual bool is_valid() const = 0;
		int get_size() const { return m_size; };
		buffer_hint get_hint() const { return m_hint; };
	protected:
		int         m_size;
		buffer_hint m_hint;
	};

} // namespace nv

#endif // NV_VERTEX_BUFFER_HH
