// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file context.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief Context class
 */

#ifndef NV_CONTEXT_HH
#define NV_CONTEXT_HH

#include <nv/common.hh>
#include <nv/interface/clear_state.hh>
#include <nv/interface/render_state.hh>

namespace nv
{
	class context
	{
	public:
		virtual void clear( const clear_state& cs ) = 0;
	protected:
		clear_state  m_clear_state;
		render_state m_render_state;
		ivec4        m_viewport;
	};

} // namespace nv

#endif // NV_CONTEXT_HH
