// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_LUA_AREA_HH
#define NV_LUA_AREA_HH

#include <nv/common.hh>
#include <nv/core/position.hh>
#include <nv/lua/lua_glm.hh>
#include <nv/lua/lua_state.hh>
#include <nv/lua/lua_values.hh>

namespace nv
{
	namespace lua
	{
		void register_area( lua_State* L );

		namespace detail
		{
			extern const char* AREA_METATABLE;
			inline bool is_area( lua_State* L, int index ) { return is_userdata( L, index, AREA_METATABLE ); }
			inline rectangle to_area( lua_State* L, int index ) { return *reinterpret_cast<rectangle*>( check_userdata( L, index, AREA_METATABLE ) ); }
			inline rectangle* to_parea( lua_State* L, int index ) { return reinterpret_cast<rectangle*>( check_userdata( L, index, AREA_METATABLE ) ); }
			inline void push_area( lua_State* L, const rectangle& v ) { push_userdata( L, v, AREA_METATABLE ); }

			inline bool is_coord( lua_State* L, int index ) { return is_vec<ivec2>( L, index ); }
			inline ivec2 to_coord( lua_State* L, int index ) { return to_vec<ivec2>( L, index ); }
			inline ivec2* to_pcoord( lua_State* L, int index ) { return to_pvec<ivec2>( L, index ); }
			inline void push_coord( lua_State* L, const ivec2& v ) { push_vec<ivec2>( L, v ); }

		}

		template<>
		struct pass_traits< rectangle >
		{
			static void push( lua_State *L, const rectangle& p ) { detail::push_area( L, p ); }
			static rectangle to( lua_State *L, int index ) { return detail::to_area( L, index ); }
		};
	}

}

#endif // NV_LUA_AREA_HH
