// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_LUA_RAW_HH
#define NV_LUA_RAW_HH

#include <nv/common.hh>
#include <nv/stl/vector.hh>
#include <nv/lib/lua.hh>
#include <nv/stl/string.hh>

void nlua_toflags_set( lua_State *L, int index, nv::uint8* data, nv::uint32 count );
void nlua_toflags_array( lua_State *L, int index, nv::uint8* data, nv::uint32 count );
void nlua_toflags( lua_State *L, int index, nv::uint8* data, nv::uint32 count );

inline nv::string_view nlua_tostringview( lua_State* L, int idx )
{
	size_t len;
	const char* str = lua_tolstring( L, idx, &len );
	return nv::string_view( str, len );
}

inline void nlua_pushstringview( lua_State* L, const nv::string_view& str )
{
	lua_pushlstring( L, str.data(), str.size() );
}

// TODO: this is not thread safe!
nv::string_view nlua_typecontent( lua_State* L, int idx );
void nlua_shallowmerge( lua_State *L, int index );
void nlua_shallowcopy( lua_State *L, int index );
void nlua_shallowicopy( lua_State *L, int index );
void nlua_deepcopy( lua_State *L, int index );
void nlua_pushreversed( lua_State *L, int index );
void nlua_toset( lua_State *L, int index );
void nlua_tokeyset( lua_State *L, int index );

nv::vector<nv::uint8> nlua_tobytearray( lua_State *L, int index );

void nlua_register( lua_State *L, const char* fname, lua_CFunction func, int index );
void nlua_register( lua_State *L, const luaL_Reg *l, int index );
void nlua_register( lua_State *L, const char* lname, const char* fname, lua_CFunction func );
void nlua_register( lua_State *L, const char* lname, const luaL_Reg *l );



#endif // NV_LUA_RAW_HH

